/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.admin.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="role")
public class Role
implements Serializable {
    private static final long serialVersionUID = 8109355439663838208L;
    public static final String STATUS_USING = "using";
    public static final String STATUS_STOPPED = "stopped";
    public static final String TYPE_WEIXIN = "WX";
    public static final String TYPE_PC = "PC";
    public static final String TYPE_ADMIN = "ADMIN";
    public static final Long MERCHANT_PUBLIC = -1L;
    private Long id;
    private String name;
    private Set<Long> permissionsSet;
    private String permissions;
    private String status;
    private Long updateAt;
    private Long updateBy;
    private Long createAt;
    private Long createBy;
    private String type;
    private Long merchantId;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="permissions")
    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    @Column(name="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="update_at")
    public Long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name="update_by")
    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name="create_at")
    public Long getCreateAt() {
        return this.createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name="create_by")
    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Transient
    public Set<Long> getPermissionsSet() {
        if (StringUtils.isBlank((CharSequence)this.permissions)) {
            return new HashSet<Long>();
        }
        if (this.permissionsSet == null) {
            Gson gson = new GsonBuilder().create();
            if (this.permissions.startsWith("{")) {
                Map map = (Map)gson.fromJson(this.permissions, new TypeToken<Map<Long, Object>>(){}.getType());
                this.permissionsSet = new HashSet(map.keySet());
            } else {
                this.permissionsSet = (Set)gson.fromJson(this.permissions, new TypeToken<List<Long>>(){}.getType());
            }
        }
        return this.permissionsSet;
    }

    public void setPermissionsSet(Set<Long> permissionsSet) {
        this.permissionsSet = permissionsSet;
        if (StringUtils.isEmpty((CharSequence)this.permissions)) {
            ArrayList<Long> permissionList = new ArrayList<Long>();
            if (StringUtils.isNotEmpty((CharSequence)this.permissions)) {
                String[] pr = this.permissions.split(",");
                for (String s : pr) {
                    permissionList.add(Long.parseLong(s));
                }
            }
            HashMap<String, String> per = new HashMap<String, String>();
            for (Long aLong : permissionList) {
                per.put(aLong.toString(), "[]");
            }
            Gson gson = new GsonBuilder().create();
            this.permissions = gson.toJson(per);
        }
    }

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="merchant_id")
    public Long getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

