package com.ptteng.keeper.home.controller;

import com.ptteng.keeper.common.model.Article;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.model.UserReadRecord;
import com.ptteng.keeper.common.service.ArticleService;
import com.ptteng.keeper.common.service.UserReadRecordService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {

    private static final Log log = LogFactory.getLog("article");
    @Autowired
    private ArticleService articleService;
    @Autowired
    private UserReadRecordService userReadRecordService;


    /**
     * 资讯详情
     *
     * @param aid id
     * @return article
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("get article data : id= " + aid+" ,uid="+user.getId());
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                log.info(article);
                if (DataUtils.isNotNullOrEmpty(article)) {
                    log.info("get article data is " + article);
                    //查用户阅读记录
                    Long rid = userReadRecordService.getUserReadRecordIdByTargetIdAndUidAndStatusAndType(aid, user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_ARTICLE);
                    //设置用户文章阅读状态为已读
                    if (DataUtils.isNullOrEmpty(rid)) {
                        UserReadRecord userReadRecord = new UserReadRecord();
                        userReadRecord.setTargetId(aid);
                        userReadRecord.setUid(user.getId());
                        userReadRecord.setStatus(UserReadRecord.STATUS_READ);
                        userReadRecord.setType(UserReadRecord.TYPE_ARTICLE);
                        userReadRecord.setCreateBy(user.getId());
                        userReadRecord.setUpdateBy(user.getId());
                        Long resultId = userReadRecordService.insert(userReadRecord);
                        log.info("create user read record success, id="+resultId);
                        //给资讯累计阅读记录
                        Integer count = article.getCount();
                        log.info("article count="+count);
                        article.setCount(count+1);
                        articleService.update(article);
                        log.info("update article count success,count="+article.getCount());
                    }else {
                        log.info("user article status is read");
                    }
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }else {
                    model.addAttribute("code", -1005);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -100000);
        }

        return "/keeper/article/json/articleDetailJson";
    }


    /**
     * 资讯列表
     *
     * @param page 页码
     * @param size 数据量
     * @param type 所属模块
     * @return Array[article] count
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Integer type)
            throws Exception {
        log.info("get article list:type="+type);
        if (DataUtils.isNullOrEmpty(type)) {
            type = 1;
        }
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        log.info("pageList : page= " + start + " , size=" + size);
        try {

            ids = articleService.getArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(type, Article.STATUS_PUSH, start, size);
            count = articleService.getArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(type, Article.STATUS_PUSH, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("get article list size is" + ids.size());
            log.info("get article total is" + total);


            List<Article> articleList = articleService.getObjectsByIds(ids);
            model.addAttribute("articleList", articleList);

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/keeper/article/json/articleListJson";
    }
}

