package com.ptteng.keeper.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.common.model.ApplyingRecord;
import com.ptteng.keeper.common.model.Product;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.service.ApplyingRecordService;
import com.ptteng.keeper.common.service.ProductService;
import com.ptteng.keeper.home.util.DynamicUtil;
import com.ptteng.keeper.home.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * ApplyingRecord  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ApplyingRecordController {
    private static final Log log = LogFactory.getLog(ApplyingRecordController.class);

    @Autowired
    private ApplyingRecordService applyingRecordService;
    @Autowired
    private ProductService productService;


    /**
     * show 申请记录
     *
     * @param status 申请状态（选填）
     * @return applyRecord product
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/apply/record", method = RequestMethod.GET)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, Integer status) throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("get apply record,id = " + user.getId()+"status="+status);
        try {
            Long start = 0L;
            Long end = System.currentTimeMillis();
            //达标--一个月内时间

            if (ApplyingRecord.STATUS_AGREE.equals(status)) {
                start = end - 2592000000L;
            }
            //未达标-一周时间
            if (ApplyingRecord.STATUS_REJECT.equals(status)) {
                start = end - 604800000L;
            }
            //取申请记录
            Map<String,Object> map = DynamicUtil.getApplyingRecord(user.getId(), status, start, end);
            List<Long> ids = applyingRecordService.getIdsByDynamicCondition(ApplyingRecord.class,map, 0,Integer.MAX_VALUE);

            List<ApplyingRecord> applyingRecordList = new ArrayList<>();
            if (ids.size() > 0) {
                applyingRecordList = applyingRecordService.getObjectsByIds(ids);
            }
            //手机加密
            for (ApplyingRecord applyingRecord : applyingRecordList) {
                applyingRecord.setMobile(StringUtil.stringEncryption(applyingRecord.getMobile()));
            }
            //取产品列表
            List<Long> pids = MyListUtil.getList(ApplyingRecord.class.getDeclaredField("productId"), applyingRecordList);
            List<Product> productList = productService.getObjectsByIds(pids);

            Integer total = ids.size();

            model.addAttribute("code", 0);

            model.addAttribute("total", total);

            model.addAttribute("applyingRecordList", applyingRecordList);
            model.addAttribute("productList", productList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  ");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/applyingRecord/json/applyingUserProductListJson";
    }


}

