/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.UserReadRecord;
import com.ptteng.keeper.common.service.UserReadRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserReadRecordServiceImpl
extends BaseDaoServiceImpl
implements UserReadRecordService {
    private static final Log log = LogFactory.getLog(UserReadRecordServiceImpl.class);

    public Long insert(UserReadRecord userReadRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userReadRecord));
        if (userReadRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userReadRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        userReadRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userReadRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userReadRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserReadRecord> insertList(List<UserReadRecord> userReadRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userReadRecordList == null ? "null" : Integer.valueOf(userReadRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userReadRecordList)) {
            return new ArrayList<UserReadRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserReadRecord userReadRecord : userReadRecordList) {
            userReadRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            userReadRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userReadRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userReadRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserReadRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserReadRecord userReadRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userReadRecord == null ? "null" : userReadRecord.getId())));
        boolean result = false;
        if (userReadRecord == null) {
            return true;
        }
        userReadRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userReadRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userReadRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userReadRecord));
        }
        return result;
    }

    public boolean updateList(List<UserReadRecord> userReadRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userReadRecordList == null ? "null" : Integer.valueOf(userReadRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userReadRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserReadRecord userReadRecord : userReadRecordList) {
            userReadRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userReadRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userReadRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userReadRecordList.size()));
        return result;
    }

    public UserReadRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserReadRecord userReadRecord = null;
        if (id == null) {
            return userReadRecord;
        }
        try {
            userReadRecord = (UserReadRecord)this.dao.get(UserReadRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userReadRecord;
    }

    public List<UserReadRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userReadRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserReadRecord>();
        }
        try {
            userReadRecord = this.dao.getList(UserReadRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userReadRecord == null ? "null" : Integer.valueOf(userReadRecord.size()))));
        return userReadRecord;
    }

    public Long getUserReadRecordIdByTargetIdAndUid(Long targetId, Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by targetId,uid  : " + targetId + " , " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserReadRecordIdByTargetIdAndUid", new Object[]{targetId, uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by targetId,uid  : " + targetId + " , " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserReadRecordIdsByUidAndStatusAndType(Long uid, Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,type,start,limit  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserReadRecordIdsByUidAndStatusAndType", new Object[]{uid, status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,type,start,limit)  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserReadRecordIdByTargetIdAndUidAndStatus(Long targetId, Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by targetId,uid,status  : " + targetId + " , " + uid + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndStatus", new Object[]{targetId, uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by targetId,uid,status  : " + targetId + " , " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserReadRecordIdByTargetIdAndUidAndType(Long targetId, Long uid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by targetId,uid,type  : " + targetId + " , " + uid + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndType", new Object[]{targetId, uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by targetId,uid,type  : " + targetId + " , " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserReadRecordIdByTargetIdAndUidAndStatusAndType(Long targetId, Long uid, Integer status, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by targetId,uid,status,type  : " + targetId + " , " + uid + " , " + status + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndStatusAndType", new Object[]{targetId, uid, status, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by targetId,uid,status,type  : " + targetId + " , " + uid + " , " + status + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countUserReadRecordIdsByUidAndStatusAndType(Long uid, Integer status, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status,type  : " + uid + " , " + status + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserReadRecordIdsByUidAndStatusAndType", new Object[]{uid, status, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status,type)  : " + uid + " , " + status + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserReadRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserReadRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserReadRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserReadRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserReadRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

