/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.UserAsset;
import com.ptteng.keeper.common.service.UserAssetService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAssetServiceImpl
extends BaseDaoServiceImpl
implements UserAssetService {
    private static final Log log = LogFactory.getLog(UserAssetServiceImpl.class);

    public Long insert(UserAsset userAsset) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userAsset));
        if (userAsset == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userAsset.setCreateAt(Long.valueOf(currentTimeMillis));
        userAsset.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userAsset);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userAsset));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserAsset> insertList(List<UserAsset> userAssetList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userAssetList == null ? "null" : Integer.valueOf(userAssetList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userAssetList)) {
            return new ArrayList<UserAsset>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserAsset userAsset : userAssetList) {
            userAsset.setCreateAt(Long.valueOf(currentTimeMillis));
            userAsset.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userAssetList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userAssetList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserAsset.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserAsset userAsset) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userAsset == null ? "null" : userAsset.getId())));
        boolean result = false;
        if (userAsset == null) {
            return true;
        }
        userAsset.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userAsset);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userAsset));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userAsset));
        }
        return result;
    }

    public boolean updateList(List<UserAsset> userAssetList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userAssetList == null ? "null" : Integer.valueOf(userAssetList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userAssetList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserAsset userAsset : userAssetList) {
            userAsset.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userAssetList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userAssetList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userAssetList.size()));
        return result;
    }

    public UserAsset getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserAsset userAsset = null;
        if (id == null) {
            return userAsset;
        }
        try {
            userAsset = (UserAsset)this.dao.get(UserAsset.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userAsset;
    }

    public List<UserAsset> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userAsset = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserAsset>();
        }
        try {
            userAsset = this.dao.getList(UserAsset.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userAsset == null ? "null" : Integer.valueOf(userAsset.size()))));
        return userAsset;
    }

    public Long getUserAssetIdByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid  : " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserAssetIdByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countUserAssetIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserAssetIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserAssetIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserAssetIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserAssetIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserAssetIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserAssetIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

