package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.WithdrawRecord;
import com.ptteng.keeper.common.service.WithdrawRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class WithdrawRecordServiceImpl extends BaseDaoServiceImpl implements WithdrawRecordService {

 

	private static final Log log = LogFactory.getLog(WithdrawRecordServiceImpl.class);



		   
		@Override
		public Long insert(WithdrawRecord withdrawRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + withdrawRecord);

		if (withdrawRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		withdrawRecord.setCreateAt(currentTimeMillis);
		withdrawRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(withdrawRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + withdrawRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<WithdrawRecord> insertList(List<WithdrawRecord> withdrawRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (withdrawRecordList == null ? "null" : withdrawRecordList.size()));
      
		List<WithdrawRecord> resultList = null;

		if (CollectionUtils.isEmpty(withdrawRecordList)) {
			return new ArrayList<WithdrawRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WithdrawRecord withdrawRecord : withdrawRecordList) {
			withdrawRecord.setCreateAt(currentTimeMillis);
			withdrawRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<WithdrawRecord>) dao.batchSave(withdrawRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + withdrawRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(WithdrawRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(WithdrawRecord withdrawRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (withdrawRecord == null ? "null" : withdrawRecord.getId()));

		boolean result = false;

		if (withdrawRecord == null) {
			return true;
		}

		withdrawRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(withdrawRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + withdrawRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + withdrawRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<WithdrawRecord> withdrawRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (withdrawRecordList == null ? "null" : withdrawRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(withdrawRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WithdrawRecord withdrawRecord : withdrawRecordList) {
			withdrawRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(withdrawRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + withdrawRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + withdrawRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public WithdrawRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		WithdrawRecord withdrawRecord = null;

		if (id == null) {
			return withdrawRecord;
		}

		try {
			withdrawRecord = (WithdrawRecord) dao.get(WithdrawRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return withdrawRecord;		
		}	
		  
    	   
		@Override
		public List<WithdrawRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<WithdrawRecord> withdrawRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<WithdrawRecord>();
		}

		try {
			withdrawRecord = (List<WithdrawRecord>) dao.getList(WithdrawRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (withdrawRecord == null ? "null" : withdrawRecord.size()));
    
		return withdrawRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getWithdrawRecordIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getWithdrawRecordIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getWithdrawRecordIdsByUidAndStatusOrderByCreateAt(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getWithdrawRecordIdsByUidAndStatusOrderByCreateAt", new Object[] { uid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countWithdrawRecordIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getWithdrawRecordIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countWithdrawRecordIdsByUidAndStatusOrderByCreateAt(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status  : " + uid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getWithdrawRecordIdsByUidAndStatusOrderByCreateAt", new Object[] { uid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status)  : " + uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getWithdrawRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getWithdrawRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countWithdrawRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWithdrawRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWithdrawRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

