/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.IncomeRecord;
import com.ptteng.keeper.common.service.IncomeRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncomeRecordServiceImpl
extends BaseDaoServiceImpl
implements IncomeRecordService {
    private static final Log log = LogFactory.getLog(IncomeRecordServiceImpl.class);

    public Long insert(IncomeRecord incomeRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + incomeRecord));
        if (incomeRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        incomeRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        incomeRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)incomeRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + incomeRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<IncomeRecord> insertList(List<IncomeRecord> incomeRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (incomeRecordList == null ? "null" : Integer.valueOf(incomeRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(incomeRecordList)) {
            return new ArrayList<IncomeRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (IncomeRecord incomeRecord : incomeRecordList) {
            incomeRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            incomeRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(incomeRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + incomeRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(IncomeRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(IncomeRecord incomeRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (incomeRecord == null ? "null" : incomeRecord.getId())));
        boolean result = false;
        if (incomeRecord == null) {
            return true;
        }
        incomeRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)incomeRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + incomeRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + incomeRecord));
        }
        return result;
    }

    public boolean updateList(List<IncomeRecord> incomeRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (incomeRecordList == null ? "null" : Integer.valueOf(incomeRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(incomeRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (IncomeRecord incomeRecord : incomeRecordList) {
            incomeRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(incomeRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + incomeRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + incomeRecordList.size()));
        return result;
    }

    public IncomeRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        IncomeRecord incomeRecord = null;
        if (id == null) {
            return incomeRecord;
        }
        try {
            incomeRecord = (IncomeRecord)this.dao.get(IncomeRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return incomeRecord;
    }

    public List<IncomeRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List incomeRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<IncomeRecord>();
        }
        try {
            incomeRecord = this.dao.getList(IncomeRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (incomeRecord == null ? "null" : Integer.valueOf(incomeRecord.size()))));
        return incomeRecord;
    }

    public List<Long> getIncomeRecordIdsByUidAndLevelOrderByCreateAt(Long uid, Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,level,start,limit  : " + uid + " , " + level + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidAndLevelOrderByCreateAt", new Object[]{uid, level}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,level,start,limit)  : " + uid + " , " + level + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt(Long uid, Integer level, Long productId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,level,productId,start,limit  : " + uid + " , " + level + " , " + productId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt", new Object[]{uid, level, productId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,level,productId,start,limit)  : " + uid + " , " + level + " , " + productId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId, Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by targetId,uid,start,limit  : " + targetId + " , " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt", new Object[]{targetId, uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by targetId,uid,start,limit)  : " + targetId + " , " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId, Long productId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by targetId,productId,start,limit  : " + targetId + " , " + productId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt", new Object[]{targetId, productId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by targetId,productId,start,limit)  : " + targetId + " , " + productId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by targetId,start,limit  : " + targetId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByTargetIdOrderByCreateAt", new Object[]{targetId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by targetId,start,limit)  : " + targetId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid, Long productId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,productId,start,limit  : " + uid + " , " + productId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidAndProductIdOrderByCreateAt", new Object[]{uid, productId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,productId,start,limit)  : " + uid + " , " + productId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByUidAndTypeOrderByCreateAt(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidAndTypeOrderByCreateAt", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt(Long uid, Integer type, Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,level,start,limit  : " + uid + " , " + type + " , " + level + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt", new Object[]{uid, type, level}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,level,start,limit)  : " + uid + " , " + type + " , " + level + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIncomeRecordIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId, Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by targetId,uid  : " + targetId + " , " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt", new Object[]{targetId, uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by targetId,uid)  : " + targetId + " , " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId, Long productId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by targetId,productId  : " + targetId + " , " + productId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt", new Object[]{targetId, productId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by targetId,productId)  : " + targetId + " , " + productId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by targetId  : " + targetId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIncomeRecordIdsByTargetIdOrderByCreateAt", new Object[]{targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by targetId)  : " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid, Long productId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,productId  : " + uid + " , " + productId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIncomeRecordIdsByUidAndProductIdOrderByCreateAt", new Object[]{uid, productId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,productId)  : " + uid + " , " + productId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countIncomeRecordIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIncomeRecordIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getIncomeRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIncomeRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIncomeRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getIncomeRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getIncomeRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

