package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.keeper.common.model.UserMessage;
import com.ptteng.keeper.common.service.UserMessageService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.UserMessage;
import com.ptteng.keeper.common.service.UserMessageService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserMessageServiceImpl extends BaseDaoServiceImpl implements UserMessageService {

 

	private static final Log log = LogFactory.getLog(UserMessageServiceImpl.class);



		   
		@Override
		public Long insert(UserMessage userMessage)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userMessage);

		if (userMessage == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userMessage.setCreateAt(currentTimeMillis);
		userMessage.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userMessage);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userMessage);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserMessage> insertList(List<UserMessage> userMessageList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userMessageList == null ? "null" : userMessageList.size()));
      
		List<UserMessage> resultList = null;

		if (CollectionUtils.isEmpty(userMessageList)) {
			return new ArrayList<UserMessage>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserMessage userMessage : userMessageList) {
			log.info("message id = "+userMessage.getMessageId());
			userMessage.setCreateAt(currentTimeMillis);
			userMessage.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserMessage>) dao.batchSave(userMessageList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userMessageList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserMessage.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserMessage userMessage)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userMessage == null ? "null" : userMessage.getId()));

		boolean result = false;

		if (userMessage == null) {
			return true;
		}

		userMessage.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userMessage);
		} catch (DaoException e) {
			log.error(" update wrong : " + userMessage);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userMessage);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserMessage> userMessageList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userMessageList == null ? "null" : userMessageList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userMessageList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserMessage userMessage : userMessageList) {
			log.info(" userMessage message id = "+userMessage.getMessageId());
			userMessage.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userMessageList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userMessageList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userMessageList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserMessage getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserMessage userMessage = null;

		if (id == null) {
			return userMessage;
		}

		try {
			userMessage = (UserMessage) dao.get(UserMessage.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userMessage;		
		}	
		  
    	   
		@Override
		public List<UserMessage> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserMessage> userMessage = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserMessage>();
		}

		try {
			userMessage = (List<UserMessage>) dao.getList(UserMessage.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userMessage == null ? "null" : userMessage.size()));
    
		return userMessage;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserMessageIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserMessageIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getUserMessageIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by type,uid,start,limit  : " +type+" , "+ uid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserMessageIdsByUidAndType", new Object[] { uid,type},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by type,uid,start,limit)  : " +type+" , " +uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserMessageIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserMessageIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserMessageIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserMessageIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserMessageIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status  : " + uid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserMessageIdsByUidAndStatus", new Object[] { uid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status)  : " + uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserMessageIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserMessageIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserMessageIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserMessageIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserMessageIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

