package com.ptteng.keeper.admin.controller;

import com.ptteng.keeper.admin.model.Constant;
import com.ptteng.keeper.admin.service.ConstantService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Constant  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ConstantController {
    private static final Log log = LogFactory.getLog(ConstantController.class);

    @Autowired
    private ConstantService constantService;

    @Autowired
    private CookieUtil cookieUtil;


    //1 新增常量
    @RequestMapping(value = "/a/u/constant", method = RequestMethod.POST)
    public String addConstantJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                  Constant constant) throws Exception {

        //打印入参
        log.info("============================================");
        log.info("new constant : constant= " + constant);

        if (constant.getType() == null) {
            model.addAttribute("code", -20000);
            log.info("type is null");
            return "/common/success";
        }

        if (constant.getName() == null) {
            model.addAttribute("code", -20001);
            log.info("name is null");
            return "/common/success";
        }
        if (constant.getValue() == null) {
            model.addAttribute("code", -20002);
            log.info("value is null");
            return "/common/success";
        }
        if (constant.getComments() == null) {
            model.addAttribute("code", -20003);
            log.info("comments is null");
            return "/common/success";
        }
        String constantValue = constantService.getConstantValueByTypeAndName(constant.getType(), constant.getName());
        log.info("constantValue =" + constantValue);
        if (DataUtils.isNotNullOrEmpty(constantValue)) {
            model.addAttribute("code", -20008);
            log.info("constant exist");
            return "/common/success";
        }

        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        constant.setCreateBy(Long.parseLong(userId));
        constant.setUpdateBy(Long.parseLong(userId));

        try {
            constant.setId(null);
            constantService.insert(constant);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add constant error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //2 获取常量详情
    @RequestMapping(value = "/a/u/constant/{id}", method = RequestMethod.GET)
    public String getconstantList(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model,
                                  @PathVariable Long id
    ) throws Exception {

        //打印入参
        log.info("============================================");
        log.info("/a/constant/" + id);
        try {
            Constant constant = constantService.getObjectById(id);
            log.info("get constant data is " + constant);

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get constant error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/constant/json/constantDetailJson";
    }


    //3 修改常量
    @RequestMapping(value = "/a/u/constant/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                     Constant constant,
                                     @PathVariable Long id
    ) throws Exception {

        //打印入参
        log.info("============================================");
        log.info("updata constant : constant= " + constant);

        if (id == null) {
            model.addAttribute("code", -20006);
            log.info("id is null");
            return "/common/success";
        }


        if (constant.getType() == null) {
            model.addAttribute("code", -20000);
            log.info("type is null");
            return "/common/success";
        }

        if (constant.getName() == null) {
            model.addAttribute("code", -20001);
            log.info("name is null");
            return "/common/success";
        }
        if (constant.getValue() == null) {
            model.addAttribute("code", -20002);
            log.info("value is null");
            return "/common/success";
        }
        if (constant.getComments() == null) {
            model.addAttribute("code", -20003);
            log.info("comments is null");
            return "/common/success";
        }

        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        Constant oldConstant = constantService.getObjectById(id);
        if (oldConstant == null) {
            model.addAttribute("code", -20007);
            log.info(id + " constant is null");
            return "/common/success";
        }


        constant.setUpdateBy(Long.parseLong(userId));


        try {
            constantService.update(constant);
            log.info(id + " constant update success");
            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update constant error,id is  " + constant.getId());
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    // 4 删除常量
//    @RequestMapping(value = "/a/u/constant/{id}", method = RequestMethod.DELETE)
//    public String deleteConstantJson(HttpServletRequest request,
//                                     HttpServletResponse response, ModelMap model,
//                                     @PathVariable Long id)
//            throws Exception {
//
//        //打印入参
//        log.info("============================================");
//        log.info("delete constant : id= " + id);
//
//        if (id == null) {
//            model.addAttribute("code", -20006);
//            model.addAttribute("message", "id is null");
//            return "/common/success";
//        }
//
//
//        try {
//            constantService.delete(id);
//            log.info("delete constant success");
//            model.addAttribute("code", 0);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("delete constant error,id is  " + id);
//            model.addAttribute("code", -1);
//        }
//        return "/common/success";
//    }

    //4 搜索常量列表
    @RequestMapping(value = "/a/u/constant/search", method = RequestMethod.GET)
    public String searchConstantList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String type, String name, String value, String comments, Long startAt, Long endAt,
            Integer page, Integer size, Long id, Long updateStartAt, Long updateEndAt)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/u/constant/search  by==type", type, "name", name, "value", value,
                "comments", comments, "startAt", startAt, "endAt", endAt, "page", page, "size", size);
        log.info(paramStr);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值
            Long total = 0L;

            //动态查询-获取参数列表
            Map<String, Object> paramList = DynamicUtil.getConstantListParam(type, name, value, comments, startAt,
                    endAt, id, updateStartAt, updateEndAt, false);
            log.info(" paramList size =  " + paramList.size());
            //获取list
            List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList, start, size);
            if (CollectionUtils.isEmpty(constantIdList)) {
                log.info(" constantIdList is null ");
            } else {
                log.info(" constantIdList size =  " + constantIdList.size());
            }
            //获取total
            Map<String, Object> paramCount = DynamicUtil.getConstantListParam(type, name, value, comments, startAt, endAt,
                    id, updateStartAt, updateEndAt, true);
            log.info("get param:" + paramCount);
            List<Long> constantIdCount = constantService.getIdsByDynamicCondition(Constant.class, paramCount, 0, Integer.MAX_VALUE);
            log.info("get constantIdCount:" + constantIdCount.size());
            if (CollectionUtils.isNotEmpty(constantIdCount)) {
                total = constantIdCount.get(0);
            }

            //获取constantList
            List<Constant> constantList = constantService.getObjectsByIds(constantIdList);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("constantList", constantList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get constant list error,page is " + page + " , size " + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/constant/json/constantListJson";
    }

}

