package com.ptteng.keeper.admin.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

public class ObjectConvertUtil {
    private static final Log log = LogFactory.getLog(ObjectConvertUtil.class);

    public static Object objectToArrayList(Object o) {
        String typeStr = o.getClass().toString();
        log.info("get object class is " + typeStr);
        List<Object[]> objects = new ArrayList<>();
        if (typeStr.contains("ArrayList")) {
            return o;
        } else if (typeStr.contains("[Ljava.lang.Object")) {
            Object[] newO = (Object[]) o;
            objects.add(newO);
        }
        return objects;
    }

    /**
     * show 数据填充 把o中没有的i内容填充进0里
     * @param o 需要被填充的原始数据
     * @param i 填充需要的数据
     * @param value 填充值
     * @return java.util.List<java.lang.Object[]>
     * @author lishaobo
     * @date    2018/9/28
     */
    public static List<Object[]>dataPadding (List<Object[]> o ,List<Long> i,Object value) {

        List<Object> arr = new ArrayList<>();
        for (Object[] a : o) {
            arr.add(a[0].toString());
        }
//        log.info("arr"+arr);
        for (Object b : i) {
//            log.info("b="+b+" !arr.contains(b)="+!arr.contains(b.toString()));
            if (!arr.contains(b.toString())){
                Object[] newO = {b,value};
                o.add(newO);
            }
        }

        return o;

    }
}
