package com.ptteng.keeper.admin.controller;

import com.ptteng.keeper.admin.utils.FeedBackUtil;
import com.ptteng.keeper.common.model.Feedback;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.service.FeedbackService;
import com.ptteng.keeper.common.service.UserService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Feedback  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class FeedbackController {
    private static final Log log = LogFactory.getLog(FeedbackController.class);

    @Autowired
    private FeedbackService feedbackService;
    @Autowired
    private UserService userService;


    @RequestMapping(value = "/a/feedback/{id}", method = RequestMethod.GET)
    public String getFeedbackJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get feedback : id= " + id);
        try {

            Feedback feedback = feedbackService.getObjectById(id);
            if (null == feedback) {
                model.addAttribute("code", 2);
                return "/common/success";
            }


            User user = userService.getObjectById(feedback.getUid());
            model.addAttribute("user", user);


            model.addAttribute("code", 0);
            model.addAttribute("feedback", feedback);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get feedback error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common-muscle-service/feedback/json/feedbackDetailJson";
    }


    @RequestMapping(value = "/a/u/feedback/{id}", method = RequestMethod.DELETE)
    public String deleteFeedbackJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete feedback : id= " + id);
        try {
            feedbackService.delete(id);

            log.info("add feedback success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete feedback error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/feedback/search", method = RequestMethod.GET)
    public String getProductIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                               HttpServletResponse response, ModelMap model, Integer page,
                                                               Integer size, String mobile, String name,
                                                               Integer type, Long startAt, Long endAt) throws Exception {

        log.info(" get bank list page = " + page + " size = " + size + " mobile = " + mobile + " name = " + name + "" +
                " type = " + type + " startAt = " + startAt + " endAt = " + endAt);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = FeedBackUtil.getFeedBackList(mobile, name, type, startAt, endAt, false);
            log.info(" get feedback list map = " + map);
            List<Long> feedBackIds = feedbackService.getIdsByDynamicCondition(Feedback.class, map, start, size);
            List<Feedback> feedBacks = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(feedBackIds)) {

                feedBacks = feedbackService.getObjectsByIds(feedBackIds);
            }
            Map<Long, User> userMap = new HashMap<>();

            if (CollectionUtils.isEmpty(feedBackIds)) {
                log.info("feedBackIds size = 0 ");

            } else {
                log.info(" feedBackIds size = " + feedBackIds.size());
                feedBacks = feedbackService.getObjectsByIds(feedBackIds);
                List<Long> userIds = new ArrayList<>();
                for (Feedback feedback : feedBacks) {
                    userIds.add(feedback.getUid());
                }

                List<User> users = userService.getObjectsByIds(userIds);
                for (User user : users) {
                    userMap.put(user.getId(), user);
                }


            }
            map = FeedBackUtil.getFeedBackList(mobile, name, type, startAt, endAt, true);
            BigInteger total = (BigInteger) feedbackService.getObjectByDynamicCondition(Feedback.class, map, 0, Integer.MAX_VALUE);
            log.info(" total = " + total);
            int totalPage = 1;
            if (total.intValue() > 0) {
                totalPage = (((total.intValue() - 1)) / (size)) + 1;
                ;
            }
            log.info(" totalPage = " + totalPage);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("feedbackList", feedBacks);
            model.addAttribute("userMap", userMap);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get feedBack list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/common-muscle-service/feedback/json/feedbackListJson";
    }


}

