package com.ptteng.keeper.admin.utils;

import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

import java.math.BigDecimal;
import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getWithdrawRecordList(String mobile, Integer status, Long createAtStart, Long createAtEnd, Long updateAtStart, Long updateAtEnd, boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("withdraw_record wr");


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("wr.status", status);
        }else {
            params.put("wr.status & >=","0" );
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("u.mobile & like", "'%" + mobile + "%'");
            params.put("u.id", "wr.uid");
            tables.add("user u");
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("wr.create_at & >=", createAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("wr.create_at & <=", createAtEnd);
        }
        if (DataUtils.isNotNullOrEmpty(updateAtStart)) {
            params.put("wr.update_at & >=", updateAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(updateAtEnd)) {
            params.put("wr.update_at & <=", updateAtEnd);
        }

        if (isCount) {
            params.put("@query", "count(wr.id) ");
        } else {
            params.put("@order", "wr.status,wr.create_at desc");
            params.put("@query", "wr.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getPreWithdarwRecord(Long uid, String status, Long createAtStart, Long createAtEnd, boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("withdraw_record wr");


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("wr.status & in", "("+status+")");
        }

        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("wr.create_at & >", createAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("wr.create_at & <", createAtEnd);
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("wr.uid", uid);

        }

        if (isCount) {
            params.put("@query", "count(wr.id) ");
        } else {
            params.put("@order", "wr.create_at desc");
            params.put("@query", "wr.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getIncomRecordList(Long createAtStart, Long createAtEnd, Long uid, Integer status, boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("income_record ir");

        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("ir.create_at & >=", createAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("ir.create_at & <=", createAtEnd);
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        params.put("type & > ", -1);

        if (isCount) {
            params.put("@query", "count(ir.id) ");
        } else {
            params.put("@order", "ir.create_at");
            params.put("@query", "ir.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getApplyingRecordList(Long id, String name, String mobile, String proxyMobile,
                                                            String productName, String idCard, Long startTime, Long endTime, Integer status, boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("applying_record ar");

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("ar.id", id);
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("ar.mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("ar.name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(idCard)) {
            params.put("ar.id_card & like ", "'%" + idCard + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("ar.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(proxyMobile)) {
            tables.add("user u");
            params.put("u.mobile & like ", "'%" + proxyMobile + "%'");
            params.put("u.id", "ar.create_by");
        }
        if (DataUtils.isNotNullOrEmpty(productName)) {
            tables.add("product p");
            params.put("p.name & like ", "'%" + productName + "%'");
            params.put("p.id", "ar.product_id");

        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("ar.create_at & >=", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("ar.create_at & <=", endTime);
        }

        if (isCount) {
            params.put("@query", "count(ar.id) ");
        } else {
            params.put("@order", "ar.create_at desc ");
            params.put("@query", "ar.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getApplyingPendingProductList(Integer status, Long productId) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("applying_record ar");
        tables.add("product p");


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("ar.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(productId)) {
            params.put("ar.product_id", productId);
        }
        params.put("p.id", "ar.product_id");

        params.put("@query", "p.name,p.id,count(ar.id)c");
        params.put("@group", "ar.product_id");
        params.put("@order", "c,ar.product_id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getProductList(Integer type, String name, Integer belongModule, Integer settleMode,
                                                     Integer status, BigDecimal amountEnd, boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(belongModule)) {
            params.put("belong_module", belongModule);
        }
        if (DataUtils.isNotNullOrEmpty(settleMode)) {
            params.put("settle_mode", settleMode);
        }
        if (DataUtils.isNotNullOrEmpty(amountEnd)) {
            params.put("amount_end", amountEnd);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "sort,status_change_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "product");

        return params;
    }

    public static Map<String, Object> getProductMaxSort(Integer type) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        params.put("@order", "sort,status_change_at desc ");
        params.put("@query", "id");
        params.put("@table", "product");

        return params;
    }

    public static Map<String, Object> getUserList(Long id, String nick, String mobile, String invitationCode, String recommendMolibe, Integer status, Long startTime, Long endTime, Integer isVip,boolean isCount) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user u");
        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("u.id", id);
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("u.mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("u.nick & like ", "'%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(invitationCode)) {
            params.put("u.invitation_code & like", "'%" + invitationCode + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(recommendMolibe)) {
            tables.add("user r");
            params.put("r.mobile & like", "'%" + recommendMolibe + "%'");
            params.put("r.id", "u.recommend_id");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("u.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("u.create_at & >= ", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(isVip)) {
            params.put("is_vip", isVip);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("u.create_at & <= ", endTime);
        }

        if (isCount) {
            params.put("@query", "count(u.id) ");
        } else {
            params.put("@order", "u.create_at desc ");
            params.put("@query", "u.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getSumAmountByUidAndLevel(Long uid, Integer level) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("income_record");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", level);
        }
        params.put("type & in", "(-1,1,2)");
        params.put("@query", "sum(amount),create_by");
        params.put("@group", "create_by");
        params.put("@order", "id desc");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getArticleListParam(String title, Integer type, Integer status, Long startTime, Long endTime, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" article.type", type);
        }

        if (DataUtils.isNotNullOrEmpty(title)) {

            params.put(" article.title & like", " '%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put(" article.status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put(" article.push_at & >=", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put(" article.push_at & <=", endTime);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc,push_at desc");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }
    public static Map<String, Object> getMessageListParam(String title, String subTitle, Integer status, Long startTime, Long endTime, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("message");

        if (DataUtils.isNotNullOrEmpty(subTitle)) {
            params.put(" message.sub_title & like",  " '%" + subTitle + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(title)) {

            params.put(" message.title & like", " '%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put(" message.status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put(" message.push_at & >=", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put(" message.push_at & <=", endTime);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc,push_at desc");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value,
                                                           String comments, Long startAt, Long endAt,
                                                           Long id, Long updateStartAt, Long updateEndAt,
                                                           boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at &  <= ", endAt);
        }

        if (DataUtils.isNotNullOrEmpty(updateStartAt)) {
            params.put("update_at & >= ", updateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(updateEndAt)) {
            params.put("update_at &  <= ", updateEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            params.put("id", id);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getManagerList(Integer status, Long roleId, String name , List<Long> createBy, Long createAtStart, Long createAtEnd,Long id, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("manager");

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ",status);
        }
        if (DataUtils.isNotNullOrEmpty(roleId)) {
            params.put(" role_id ",roleId);
        }
        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put(" id ",id);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (CollectionUtils.isNotEmpty(createBy)) {
            params.put(" create_by & in ", "("+StringUtils.join(createBy,",")+")");
        }else {
            params.put(" create_by", "-10000");
        }

        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("update_at & >= ", createAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("update_at &  <= ", createAtEnd);
        }



        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getManagerByName(String name ,boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("manager");


        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getUserIncomeRecordByType(String types,Long uid) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("income_record");


        if (DataUtils.isNotNullOrEmpty(types)) {
            params.put(" type & in ", "(" + types + ")");
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" uid ", uid);
        }

        params.put("@order", " update_at desc  ");
        params.put("@query", " id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getTeamAllUserIds(List<Long> uids) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");


        if (CollectionUtils.isNotEmpty(uids)) {
            params.put(" recommend_id & in ", "(" + StringUtils.join(uids, ",") + ")");
        }else {
            params.put(" recommend_id","-1");
        }

        params.put("@order", " update_at desc  ");
        params.put("@query", " id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> updateUsersTeamUid(List<Long> uids,Long id) {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@table","user");
        params.put("@update","");
        params.put("@field","team_uid");
        params.put("@value",id+"");
        params.put("id & in ", "("+StringUtils.join(uids,",")+")");
        log.info(SQLUtil.convert2Sql(params,0,Integer.MAX_VALUE));

        return params;
    }
    public static Map<String, Object> updateUsersVipAt(List<Long> uids) {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@table","user");
        params.put("@update","");
        params.put("@field","vip_at");
        params.put("@value",System.currentTimeMillis()+"");
        params.put("id & in ", "("+StringUtils.join(uids,",")+")");
        log.info(SQLUtil.convert2Sql(params,0,Integer.MAX_VALUE));

        return params;
    }
    public static Map<String, Object> updateDataByTableAndFieldAndValue(String table,String field,String value,String condition) {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@table",table);
        params.put("@update","");
        params.put("@field",field);
        params.put("@value",value);
        if (DataUtils.isNotNullOrEmpty(condition)) {
            params.put("1=1 & and ", condition);
        }
        log.info(SQLUtil.convert2Sql(params,0,Integer.MAX_VALUE));

        return params;
    }
    public static Map<String, Object> getVipTeamMemberList(Long uid,Long createAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");


        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" team_uid ",uid);
        }
        if (DataUtils.isNotNullOrEmpty(createAt)) {
            params.put(" create_at & <=",createAt);
        }
        params.put("@order", " create_at desc  ");
        params.put("@query", " id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getVipUserList(String query,Long uid) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(query)) {
            params.put("(nick & like ","'%"+query+"%' or mobile like '%"+query+"%' or invitation_code like '%"+query+"%')" );
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("id",uid);
        }

        params.put("is_vip", "1");
        params.put("@order", " create_at desc  ");
        params.put("@query", " id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getVipTeamMemberCount(List<Long> uids,Long endAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        if (CollectionUtils.isNotEmpty(uids)) {
            params.put(" team_uid & in ","("+StringUtils.join(uids,",")+")");
        }else {
            params.put("team_uid & =", "-1000");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" create_at & <=",endAt);
        }
        params.put("@order", " create_at desc  ");
        params.put("@query", " team_uid,count(id) ");
        params.put("@group", " team_uid");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getTeamMemberSearch(Long uid,Long startAt,Long endAt,String query,Integer level) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" team_uid ",uid);
        }else {
            params.put("team_uid & !=", "-1");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" create_at & <=",endAt);
        }
        if (DataUtils.isNotNullOrEmpty(query)) {
            params.put("( nick & like ","'%"+query+"%' or mobile like '%"+query+"%' or invitation_code like '%"+query+"%')" );
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" create_at & >=",startAt);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put(" level ",level);
        }
        params.put("@order", " create_at desc  ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getVipTeamAmount(List<Long> uids,Long start,Long endAt,String types) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user u");
        tables.add("income_record ir");


        if (CollectionUtils.isNotEmpty(uids)) {
            params.put(" u.team_uid & in ","("+StringUtils.join(uids,",")+")");
        }else {
            params.put("u.team_uid & =", "-1000");
        }
        String startSQL = "";
        if (DataUtils.isNotNullOrEmpty(start)) {
            startSQL =" and ir.create_at >= (case when "+start+" > u.vip_at then "+start + " else u.vip_at end)";
        }
        String endSQL = "";
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            endSQL =" and ir.create_at <="+endAt;
        }

        String typeSQL = "";
        if (DataUtils.isNotNullOrEmpty(types)) {
            typeSQL = " in ("+types+")";
        }

        params.put("@order", " u.team_uid");

        params.put("@query", "u.team_uid,sum(case when type "+ typeSQL+ " and ir.status=1 and u.vip_at<=ir.create_at and ir.uid=u.id "+startSQL+endSQL+" then ir.amount else 0 end)amount");


        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        params.put("@group", "u.team_uid");
        return params;
    }
    public static Map<String, Object> getTeamGrossProfit(List<Long> uids,Long start,Long endAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("income_record");

        if (CollectionUtils.isNotEmpty(uids)) {
            params.put(" uid & in ","("+StringUtils.join(uids,",")+")");
        }else {
            params.put("uid", "-1000");
        }

        if (DataUtils.isNotNullOrEmpty(start)) {
            params.put("create_at & >= ", start);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at & <= ", endAt);
        }
        params.put("type", "3");
        params.put("@query", "uid,sum(amount)amount");


        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        params.put("@group", "uid");
        return params;
    }
}


