package com.ptteng.keeper.admin.controller;

import com.ptteng.keeper.admin.interceptor.CookieConstant;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.model.Role;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.pwd.PasswordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
public class SystemController {
    private static final Log log = LogFactory.getLog(SystemController.class);

    @Autowired
    private ManagerService managerService;


    @Autowired
    private RoleService roleService;

    @Autowired
    private CookieUtil cookieUtil;

    /**
     * 游戏准备
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/login/index")
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info(" welcome to manager index ");

        return "/index";
    }

    /**
     * 游戏准备
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/test")
    public String test(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info(" welcome to manager index ");
        return "/demo/test";
    }


    @RequestMapping(value = "/nologin")
    public String noLogin(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, Integer page,
                          Integer size) throws Exception {
        log.info(" login wrong ");
        model.addAttribute("code", -3);
        return "/data/json";
    }

    @RequestMapping(value = "/noPermissin")
    public String noPermission(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Integer page,
                               Integer size) throws Exception {
        log.info(" login noPermission ");
        model.addAttribute("code", -4);
        return "/data/json";
    }


    /**
     * 管理员登录
     *
     * @param request
     * @param response
     * @param model
     * @param name
     * @param pwd
     * @return
     */

    //1、管理员登录
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String pwd) {
        log.info(" welcome to manager login ");

        try {
            List<Long> managerIds = this.managerService.getManagerIdsByName(name, 0, Integer.MAX_VALUE);
            if (managerIds == null || managerIds.isEmpty() || managerIds.size() > 1) {
                log.info(name + " not get any user ");
                model.addAttribute("code", -5003);
                return "/common/success";

            } else {
                log.info(name + "  get user " + managerIds.get(0));
                Manager manager = this.managerService.getObjectById(managerIds.get(0));
                if (PasswordUtils.authenticatePassword(manager.getPwd(), pwd) && manager.getStatus().equals(Manager.STATUS_USING)) {
                    log.info(managerIds.get(0) + " login ");
                    Map<String, String> maps = new HashMap();
                    maps.put(CookieConstant.Cookie_WEB_ManagerName, manager.getName());


                    maps.put(CookieUtil.USER_ID, manager.getId() + "");
                    cookieUtil.setIdentity(request, response, maps, manager.getId());

                    Role role = roleService.getObjectById(manager.getRoleID());
                    model.addAttribute("code", 0);
                    model.addAttribute("manager", manager);
                    model.addAttribute("role", role);
                    log.info(managerIds.get(0) + " login over ");
                } else {
                    log.info(managerIds.get(0) + " has wrong pwd ");
                    model.addAttribute("code", -10);
                    model.addAttribute("result", null);
                    return "/common/success";
                }
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager login error,name is  " + name);
            model.addAttribute("code", -1);
            model.addAttribute("result", null);
        }

        return "/data/login";
    }

    /**
     * 退出系统
     *
     * @param request
     * @param response
     * @param model
     * @return
     */

    //2.注销
    @RequestMapping(value = "/a/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);
            model.addAttribute("result", "/login/index");

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -5005);
            model.addAttribute("result", null);
        }

        return "/data/json";
    }


}
