package com.ptteng.keeper.admin.controller;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.admin.utils.PropertiesUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxmlformats.schemas.drawingml.x2006.main.STAdjAngle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * WithdrawRecord  crud
 *
 * @author lishoabo
 * @Date 2018-08-01 13:43
 */
@Controller
public class WithdrawRecordController {
    private static final Log log = LogFactory.getLog(WithdrawRecordController.class);

    @Autowired
    private WithdrawRecordService withdrawRecordService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ApplyingRecordService applyingRecordService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private WithdrawIncomeRelationService withdrawIncomeRelationService;

    @Resource(name = "alipayConfig")
    private Map<String, String> alipayConfig;
    private AlipayClient alipayClient;
    private static final Map<String, String> ALIPAY_CODE = PropertiesUtil.propertesToMap(PropertiesUtil.loadFilesToProps("cfg/excel.properties"));

    /**
     * show 提现列表
     *
     * @param mobile        手机号
     * @param status        提现状态
     * @param createAtStart 申请时间开始
     * @param createAtEnd   申请时间结束
     * @param updateAtStart 处理时间开始
     * @param updateAtEnd   处理时间结束
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/search", method = RequestMethod.GET)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, Integer page,
                                                                            Integer size, String mobile, Integer status, Long createAtStart, Long createAtEnd, Long updateAtStart, Long updateAtEnd) throws Exception {
        log.info("withdraw record search:" + LogUtil.convertParam("mobile", mobile, "status", status, "createAtStart", createAtStart, "createAtEnd", createAtEnd,
                "updateAtStart", updateAtStart, "updateAtEnd", updateAtEnd));

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> map = DynamicUtil.getWithdrawRecordList(mobile, status, createAtStart, createAtEnd, updateAtStart, updateAtEnd, false);
            Map<String, Object> totalMap = DynamicUtil.getWithdrawRecordList(mobile, status, createAtStart, createAtEnd, updateAtStart, updateAtEnd, true);
            List<Long> ids = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, start, size);
            List<WithdrawRecord> withdrawRecordList = withdrawRecordService.getObjectsByIds(ids);

            BigInteger total = (BigInteger) withdrawRecordService.getObjectByDynamicCondition(WithdrawRecord.class, totalMap, 0, Integer.MAX_VALUE);

            List<Long> uids = MyListUtil.getList(WithdrawRecord.class.getDeclaredField("uid"), withdrawRecordList);
            List<User> userList = userService.getObjectsByIds(uids);

            List<Long> mids = MyListUtil.getList(WithdrawRecord.class.getDeclaredField("updateBy"), withdrawRecordList);
            List<Manager> managerList = managerService.getObjectsByIds(mids);
            log.info("pids size= " + mids.size());

            log.info("get withdraw record size is " + total);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("withdrawRecordList", withdrawRecordList);
            model.addAttribute("userList", userList);
            model.addAttribute("managerList", managerList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/withdrawRecord/json/withdrawRecordListJson";
    }

    /**
     * show 提现详情
     *
     * @param id 提现单号
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/{id}", method = RequestMethod.GET)
    public String getWithdrawDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("withdraw record detail:id=" + id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1100);
            return "/common/success";
        }
        try {
            //获取提现记录
            WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
            //此次发起记录时间
            Long start = 0L;
            Long end = withdrawRecord.getCreateAt();
            log.info("本次提现时间 " + MyTimeUtil.convertLong2String(withdrawRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));
            //获取上次提现记录
            WithdrawRecord lastRecord;
            Map<String, Object> map = DynamicUtil.getPreWithdarwRecord(withdrawRecord.getUid(), "10,20,30,40,50", null, withdrawRecord.getCreateAt(), false);
            List<Long> lastRecordIds = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, 0, Integer.MAX_VALUE);
            if (lastRecordIds.size() > 0) {
                Long lastId = lastRecordIds.get(0);
                lastRecord = withdrawRecordService.getObjectById(lastId);
                start = lastRecord.getCreateAt();
                log.info("上次提现时间（非拒绝）" + MyTimeUtil.convertLong2String(lastRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));

            }
            log.info("收入时间区间" + MyTimeUtil.convertLong2String(start, "YY-MM-dd HH:mm:ss") + " - " + MyTimeUtil.convertLong2String(end, "YY-MM-dd HH:mm:ss"));
            //获取上次提现、到此次提现的收入记录
            Map<String, Object> map2 = DynamicUtil.getIncomRecordList(start, end, withdrawRecord.getUid(), null, false);
            List<Long> ids = incomeRecordService.getIdsByDynamicCondition(IncomeRecord.class, map2, 0, Integer.MAX_VALUE);
            List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(ids);

            //取历史记录中的失败合法收入
            List<Long> oids = withdrawIncomeRelationService.getIncomeRecordIdsByWid(id, 0, Integer.MAX_VALUE);
            if (!oids.isEmpty()){
                log.info("历史记录中存在失败的记录，此次一起提现,size is"+oids.size());
                oids.removeAll(ids);
                List<IncomeRecord> oIncomeRecordList= incomeRecordService.getObjectsByIds(oids);
                incomeRecordList.addAll(oIncomeRecordList);
            }


            for (IncomeRecord incomeRecord : incomeRecordList) {
                log.info("收入时间" + MyTimeUtil.convertLong2String(incomeRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));

            }
            List<Long> pids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("productId"), incomeRecordList);
            List<Product> productList = productService.getObjectsByIds(pids);
            //申请单
            List<Long> aids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("targetId"), incomeRecordList);
            List<ApplyingRecord> applyingRecordList = applyingRecordService.getObjectsByIds(aids);
            model.addAttribute("code", 0);

            model.addAttribute("incomeRecordList", incomeRecordList);
            model.addAttribute("productList", productList);
            model.addAttribute("applyingRecordList", applyingRecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord detail error ");
            // for test
            model.addAttribute("code", -1);
        }

        return "/keeper/incomeRecord/json/incomeRecordListJson";
    }

    /**
     * show 提现核验
     *
     * @param ids        通过记录id
     * @param withdrawId 提现申请单id
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/withdraw/{withdrawId}/verify", method = RequestMethod.PUT)
    public String getWithdrawDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody List<Long> ids, @PathVariable Long withdrawId) throws Exception {
        synchronized (this) {
            log.info("withdraw record verify:ids=" + ids + " ,withdrawId=" + withdrawId);

            if (DataUtils.isNullOrEmpty(withdrawId)) {
                model.addAttribute("code", -1100);
                return "/common/success";
            }
            try {
                //获取提现记录
                WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(withdrawId);
                //校验提现单状态，非申请中的不再处理
                if (!WithdrawRecord.STATUS_APPLYING.equals(withdrawRecord.getStatus())) {
                    model.addAttribute("code", -5030);
                    return "common/success";
                }

                //此次发起记录时间
                Long start = 0L;
                Long end = withdrawRecord.getCreateAt();
                log.info("本次提现时间 " + MyTimeUtil.convertLong2String(withdrawRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));
                //获取上次提现记录
                WithdrawRecord lastRecord;
                Map<String, Object> map = DynamicUtil.getPreWithdarwRecord(withdrawRecord.getUid(), "10,20,30,40,50", null, withdrawRecord.getCreateAt(), false);
                List<Long> lastRecordIds = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, 0, Integer.MAX_VALUE);
                if (lastRecordIds.size() > 0) {
                    Long lastId = lastRecordIds.get(0);
                    lastRecord = withdrawRecordService.getObjectById(lastId);
                    start = lastRecord.getCreateAt();
                    log.info("上次提现时间（非拒绝）" + MyTimeUtil.convertLong2String(lastRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));

                }
                log.info("收入时间区间" + MyTimeUtil.convertLong2String(start, "YY-MM-dd HH:mm:ss") + " - " + MyTimeUtil.convertLong2String(end, "YY-MM-dd HH:mm:ss"));
                //获取上次提现、到此次提现的收入记录
                Map<String, Object> map2 = DynamicUtil.getIncomRecordList(start, end, withdrawRecord.getUid(), null, false);
                List<Long> allIds = incomeRecordService.getIdsByDynamicCondition(IncomeRecord.class, map2, 0, Integer.MAX_VALUE);
                List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(allIds);


                //取历史记录中的失败合法收入
                List<Long> oids = withdrawIncomeRelationService.getIncomeRecordIdsByWid(withdrawId, 0, Integer.MAX_VALUE);
                log.info("历史记录中存在失败的记录，此次一起提现,size is"+oids.size());
                oids.removeAll(allIds);
                List<IncomeRecord> oIncomeRecordList= incomeRecordService.getObjectsByIds(oids);
                incomeRecordList.addAll(oIncomeRecordList);

                for (IncomeRecord incomeRecord : incomeRecordList) {
                    log.info("收入时间" + MyTimeUtil.convertLong2String(incomeRecord.getCreateAt(), "YY-MM-dd HH:mm:ss"));

                }
                Map<Long, IncomeRecord> incomeRecordMap = MyListUtil.convert2Map(IncomeRecord.class.getDeclaredField("id"), incomeRecordList);
                //本次提现总额
                BigDecimal allAmonut = BigDecimal.ZERO;
                //本次拒绝的金额
                BigDecimal disagreeAmonut = BigDecimal.ZERO;

                //先全部设置为拒绝
                List<IncomeRecord> allList = new ArrayList<>();
                for (Long id : allIds) {
                    IncomeRecord incomeRecord = incomeRecordMap.get(id);
                    incomeRecord.setStatus(IncomeRecord.STATUS_DISABLED);
                    //关联提现记录
                    incomeRecord.setWrId(withdrawId);
                    //累加总额
                    allAmonut = allAmonut.add(incomeRecord.getAmount());
                    allList.add(incomeRecord);
                }
                //通过收入列表
                List<IncomeRecord> updateList = new ArrayList<>();

                List<IncomeRecord> agreeIncomeRecordList = incomeRecordService.getObjectsByIds(ids);
                //计算通过的总收入
                BigDecimal agreeAmount = BigDecimal.ZERO;
                for (IncomeRecord incomeRecord : agreeIncomeRecordList) {
                    agreeAmount = agreeAmount.add(incomeRecord.getAmount());
                    incomeRecord.setStatus(IncomeRecord.STATUS_ENABLED);
                    updateList.add(incomeRecord);
                    log.info(updateList);
                }
                //去重+添加
                boolean b = allList.removeAll(updateList);
                log.info("remove " + b);
                allList.addAll(updateList);

                incomeRecordService.updateList(allList);
                log.info("user income record update success");
                //处理用户提现金额
                log.info("user withdraw amount from " + withdrawRecord.getAmount() + " to " + agreeAmount);
                withdrawRecord.setAmount(agreeAmount);
                //被拒绝的金额
                disagreeAmonut = allAmonut.subtract(agreeAmount);
                withdrawRecord.setDisagreeAmount(disagreeAmonut);
                withdrawRecordService.update(withdrawRecord);
                log.info("user withdrawRecord update success");
                model.addAttribute("code", 0);
            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("get withdrawRecord detail error ");
                // for test
                model.addAttribute("code", -1);
            }

            return "/common/success";
        }
    }

//    /**
//     * show 提现审批-支付宝自动转账
//     *
//     * @param id     申请id
//     * @param status 状态 2通过 3拒绝
//     * @return 操作结果
//     * @throws Exception 异常信息
//     * @author lishaobo
//     * @date 2018/8/4
//     */
//    @RequestMapping(value = "/a/u/withdraw/{id}/status", method = RequestMethod.PUT)
//    public String updateWithdrawRecordJson(HttpServletRequest request,
//                                           HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status, String remark) throws Exception {
//        synchronized (this) {
//            Integer[] statusConstant = {WithdrawRecord.STATUS_APPLYING, WithdrawRecord.STATUS_AGREE, WithdrawRecord.STATUS_REJECT, WithdrawRecord.STATUS_ALIPAY_PROCESSING, WithdrawRecord.STATUS_ALIPAY_FAIL};
//
//            log.info("update withdrawRecord  status: id= " + id + " ,status=" + status + " ,remark=" + remark);
//            if (DataUtils.isNullOrEmpty(id)) {
//                model.addAttribute("code", -1100);
//                return "/common/success";
//            }
//            if (DataUtils.isNullOrEmpty(status)) {
//                model.addAttribute("code", -2002);
//                return "/common/success";
//            } else if (!Arrays.asList(statusConstant).contains(status)) {
//                model.addAttribute("code", -2002);
//                return "/common/success";
//            }
//            if (DataUtils.isNullOrEmpty(remark)) {
//                remark = Constants.DEFAULT_STR_NONE;
//            }
//            Manager manager = (Manager) request.getAttribute("manager");
//            try {
//                WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
//                if (DataUtils.isNullOrEmpty(withdrawRecord)) {
//                    model.addAttribute("code", -1005);
//                    return "/common/success";
//                }
//                //拒绝或部分拒绝remark必填
//                if (WithdrawRecord.STATUS_REJECT.equals(status) && DataUtils.isNullOrEmpty(remark)) {
//                    model.addAttribute("code", -3027);
//                    return "/common/success";
//                } else if (WithdrawRecord.STATUS_AGREE.equals(status) && withdrawRecord.getDisagreeAmount().compareTo(BigDecimal.ZERO) > 0 && DataUtils.isNullOrEmpty(remark)) {
//                    model.addAttribute("code", -3027);
//                    return "/common/success";
//                }
//                withdrawRecord.setStatus(status);
//                withdrawRecord.setRemark(remark);
//                withdrawRecord.setUpdateBy(manager.getId());
//
//                UserAsset userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
//                //设置重置用户资产
//                log.info("user applyingAmount=" + userAsset.getApplyingAmount());
//                //通过or拒绝：申请中金额=申请中金额-(本次通过的金额+本次拒绝的金额)
//                log.info("=======当前申请中金额为======");
//                log.info("=======" + userAsset.getApplyingAmount() + "======");
//                log.info("=============");
//                log.info("=======本次通过的金额为======");
//                log.info("=======" + withdrawRecord.getAmount() + "======");
//                log.info("=============");
//                log.info("=======本次拒绝的金额为======");
//                log.info("=======" + withdrawRecord.getDisagreeAmount() + "======");
//                log.info("=============");
//
//                userAsset.setApplyingAmount(userAsset.getApplyingAmount().subtract(withdrawRecord.getAmount().add(withdrawRecord.getDisagreeAmount())));
//                if (userAsset.getApplyingAmount().compareTo(BigDecimal.ZERO) < 0) {
//                    //出现提现中的金额为负数
//                    log.error("======= set applying error ===========");
//                    log.error("userAsset=" + userAsset + " ,withdrawRecord=" + withdrawRecord);
//                    model.addAttribute("code", -1);
//                    return "/common/success";
//                }
//                log.info("user applyingAmount=" + userAsset.getApplyingAmount() + " surplusAmount=" + userAsset.getSurplusAmount());
//
//
//                //支付宝转账流程
//                if (WithdrawRecord.STATUS_AGREE.equals(status)) {
//                    Long start = System.currentTimeMillis();
//                    log.info("============ alipay start ===========");
//                    String orderNo = withdrawRecord.getOrderNo();
//                    String alipayAccount = withdrawRecord.getAlipayAccount();
//                    BigDecimal amount = withdrawRecord.getAmount();
//                    String payeeName = withdrawRecord.getPayeeName();
//
//                    log.info("orderNo=" + orderNo + " ,alipayAccount=" + alipayAccount + " ,amount=" + amount + " ,payeeName=" + payeeName);
//                    AlipayFundTransToaccountTransferResponse rs = makeATransfer(orderNo, alipayAccount, amount, payeeName);
//                    if (rs.isSuccess()) {
//                        withdrawRecord.setSerialNumber(rs.getOrderId());
//                        log.info("支付宝转账调用成功");
//                    } else {
//                        status = WithdrawRecord.STATUS_ALIPAY_FAIL;
//                        String alipayRemark = rs.getSubMsg();
//                        //提示失败，并且返回码为"SYSTEM_ERROR",则为支付宝无法准确判定结果，重发请求
//                        if ("SYSTEM_ERROR".equals(rs.getSubCode())) {
//                            rs = makeATransfer(orderNo, alipayAccount, amount, payeeName);
//                            if (rs.isSuccess()) {
//                                withdrawRecord.setSerialNumber(rs.getOrderId());
//                                status = WithdrawRecord.STATUS_AGREE;
//                                alipayRemark = "";
//                            }
//                        }
//                        withdrawRecord.setStatus(status);
//                        withdrawRecord.setAlipayRemark(alipayRemark);
//                        log.info("支付宝转账调用" + rs.isSuccess());
//                    }
//                    Long end = System.currentTimeMillis();
//                    log.info("支付宝转账耗时：" + (end - start) + " ms");
//                }
//                withdrawRecordService.update(withdrawRecord);
//
//                //支付宝转账失败，将用户的提现中有效金额返回到余额中,重置收入记录中通过的部分与提现申请的关系
//                if (WithdrawRecord.STATUS_ALIPAY_FAIL.equals(status)) {
//                    userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
//                    log.info("=== alipay fail ===");
//                    BigDecimal surplusAmount = userAsset.getSurplusAmount();
//                    BigDecimal amount = withdrawRecord.getAmount();
//                    log.info("surplusAmount=" + surplusAmount + " ,amount=" + amount);
//                    userAsset.setApplyingAmount(userAsset.getApplyingAmount().subtract(withdrawRecord.getAmount().add(withdrawRecord.getDisagreeAmount())));
//                    userAsset.setSurplusAmount(surplusAmount.add(amount));
//
//
//                    //获取这笔申请的合法收入记录,并将关联提现单重置
//                    List<Long>ids =incomeRecordService.getIncomeRecordIdsByWrId(withdrawRecord.getId(),withdrawRecord.getUid(), 0, Integer.MAX_VALUE);
//                    log.info("ids size is "+ids.size());
//                    List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(ids);
//                    for (IncomeRecord incomeRecord : incomeRecordList) {
//                        incomeRecord.setWrId(Constants.DEFAULT_LONG_NONE);
//                    }
//                    incomeRecordService.updateList(incomeRecordList);
//
//                }
//
//
//                log.info("update withdraw record success");
//                userAssetService.update(userAsset);
//                log.info("update user asset success");
//                model.addAttribute("code", 0);
//
//                model.addAttribute("code", 0);
//            } catch (Throwable t) {
//                t.printStackTrace();
//                log.error(t.getMessage());
//                log.error("update withdrawRecord error,id is  " + id);
//                model.addAttribute("code", -1);
//
//            }
//            return "/data/json";
//        }
//    }

    private AlipayFundTransToaccountTransferResponse makeATransfer(String orderNo, String alipayAccount, BigDecimal amount, String payeeName) throws Exception {

        AlipayFundTransToaccountTransferRequest rq = new AlipayFundTransToaccountTransferRequest();
        AlipayFundTransToaccountTransferResponse rs = new AlipayFundTransToaccountTransferResponse();
        rq.setBizContent("{" +
                "    \"out_biz_no\":\"" + orderNo + "\"," +
                "    \"payee_type\":\"ALIPAY_LOGONID\"," +
                "    \"payee_account\":\"" + alipayAccount + "\"," +
                "    \"amount\":\"" + amount + "\"," +
                "    \"payee_real_name\":\"" + payeeName + "\"," +
                "    \"remark\":\"应急掌柜支付宝提现\"," +
                "  }");

        rs = alipayClient.execute(rq);
        log.info(rs.toString());
        return rs;
    }

    /**
     * show 提现审批-支付宝手动转账
     *
     * @param id           申请id
     * @param status       状态 2通过 3拒绝 9处理中 10失败
     * @param alipayRemark 支付宝失败原因
     * @param serialNumber 支付宝流水号
     * @param remark       驳回原因
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/v2/withdraw/{id}/status", method = RequestMethod.PUT)
    public String updateWithdrawRecordV2(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status, String remark, String alipayRemark, String serialNumber) throws Exception {
        synchronized (this) {
            log.info("update withdrawRecord  status: id= " + id + " ,status=" + status + " ,remark=" + remark + " ,alipayRemark=" + alipayRemark + " ,serialNumber=" + serialNumber);
            Integer[] statusConstant = {WithdrawRecord.STATUS_APPLYING, WithdrawRecord.STATUS_AGREE, WithdrawRecord.STATUS_REJECT, WithdrawRecord.STATUS_ALIPAY_PROCESSING, WithdrawRecord.STATUS_ALIPAY_FAIL};
            if (DataUtils.isNullOrEmpty(id)) {
                model.addAttribute("code", -1100);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(status)) {
                model.addAttribute("code", -2002);
                return "/common/success";
            } else if (!Arrays.asList(statusConstant).contains(status)) {
                model.addAttribute("code", -2002);
                return "/common/success";
            }

            if (DataUtils.isNullOrEmpty(remark)) {
                remark = Constants.DEFAULT_STR_NONE;
            }
            Manager manager = (Manager) request.getAttribute("manager");
            try {
                WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
                if (DataUtils.isNullOrEmpty(withdrawRecord)) {
                    model.addAttribute("code", -1005);
                    return "/common/success";
                }


                //拒绝或部分拒绝,必须是申请中的状态,remark必填
                if (WithdrawRecord.STATUS_ALIPAY_PROCESSING.equals(status) || WithdrawRecord.STATUS_REJECT.equals(status)) {
                    if (!withdrawRecord.getStatus().equals(WithdrawRecord.STATUS_APPLYING)) {
                        model.addAttribute("code", -3031);
                        return "/common/success";
                    }
                    if (WithdrawRecord.STATUS_REJECT.equals(status) && DataUtils.isNullOrEmpty(remark)) {
                        model.addAttribute("code", -3027);
                        return "/common/success";
                    } else if (WithdrawRecord.STATUS_ALIPAY_PROCESSING.equals(status) && withdrawRecord.getDisagreeAmount().compareTo(BigDecimal.ZERO) > 0 && DataUtils.isNullOrEmpty(remark)) {
                        model.addAttribute("code", -3027);
                        return "/common/success";
                    }
                }

                withdrawRecord.setRemark(remark);

                //支付宝失败，alipayRemark必填serialNumber必填
                if (WithdrawRecord.STATUS_ALIPAY_FAIL.equals(status)) {
                    //校验申请状态是否在处理中
                    if (!withdrawRecord.getStatus().equals(WithdrawRecord.STATUS_ALIPAY_PROCESSING)) {
                        model.addAttribute("code", -3030);
                        return "/common/success";
                    }

                    if (DataUtils.isNullOrEmpty(alipayRemark)) {
                        model.addAttribute("code", -3028);
                        return "/common/success";
                    }

                    if (DataUtils.isNullOrEmpty(serialNumber)) {
                        model.addAttribute("code", -3029);
                        return "/common/success";
                    }
                    withdrawRecord.setAlipayRemark(alipayRemark);
                    withdrawRecord.setSerialNumber(serialNumber);

                }
                //支付宝成功，serialNumber必填
                if (WithdrawRecord.STATUS_AGREE.equals(status)) {
                    //校验申请状态是否在处理中
                    if (!withdrawRecord.getStatus().equals(WithdrawRecord.STATUS_ALIPAY_PROCESSING)) {
                        model.addAttribute("code", -3030);
                        return "/common/success";
                    }

                    if (DataUtils.isNullOrEmpty(serialNumber)) {
                        model.addAttribute("code", -3029);
                        return "/common/success";
                    }
                    withdrawRecord.setSerialNumber(serialNumber);
                }

                withdrawRecord.setStatus(status);
                withdrawRecord.setUpdateBy(manager.getId());
                withdrawRecordService.update(withdrawRecord);
                log.info("update withdraw record success");
                UserAsset userAsset;

                //成功or拒绝，重新计算申请中的金额：申请中金额=申请中金额-(本次通过的金额+本次拒绝的金额)
                if (status.equals(WithdrawRecord.STATUS_AGREE) || status.equals(WithdrawRecord.STATUS_REJECT)) {
                    //设置重置用户资产
                    userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
                    log.info("user applyingAmount=" + userAsset.getApplyingAmount());
                    log.info("=======当前申请中金额为======");
                    log.info("=======" + userAsset.getApplyingAmount() + "======");
                    log.info("=============");
                    log.info("=======本次通过的金额为======");
                    log.info("=======" + withdrawRecord.getAmount() + "======");
                    log.info("=============");
                    log.info("=======本次拒绝的金额为======");
                    log.info("=======" + withdrawRecord.getDisagreeAmount() + "======");
                    log.info("=============");

                    userAsset.setApplyingAmount(userAsset.getApplyingAmount().subtract(withdrawRecord.getAmount().add(withdrawRecord.getDisagreeAmount())));
                    if (userAsset.getApplyingAmount().compareTo(BigDecimal.ZERO) < 0) {
                        //出现提现中的金额为负数
                        log.error("======= set applying error ===========");
                        log.error("userAsset=" + userAsset + " ,withdrawRecord=" + withdrawRecord);
                        model.addAttribute("code", -1);
                        return "/common/success";
                    }
                    log.info("user applyingAmount=" + userAsset.getApplyingAmount() + " surplusAmount=" + userAsset.getSurplusAmount());
                    userAssetService.update(userAsset);
                    log.info("update user asset success");
                } else if (WithdrawRecord.STATUS_ALIPAY_FAIL.equals(status)) {
                    //支付宝转账失败，将用户的提现中有效金额返回到余额中
                    userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
                    log.info("=== alipay fail ===");
                    BigDecimal surplusAmount = userAsset.getSurplusAmount();
                    BigDecimal amount = withdrawRecord.getAmount();
                    log.info("surplusAmount=" + surplusAmount + " ,amount=" + amount);
                    userAsset.setApplyingAmount(userAsset.getApplyingAmount().subtract(withdrawRecord.getAmount().add(withdrawRecord.getDisagreeAmount())));
                    userAsset.setSurplusAmount(surplusAmount.add(amount));
                    userAssetService.update(userAsset);
                    log.info("update user asset success");
                    //获取这笔申请的合法收入记录,并将关联提现单重置
                    List<Long>ids =incomeRecordService.getIncomeRecordIdsByWrId(withdrawRecord.getId(),withdrawRecord.getUid(), 0, Integer.MAX_VALUE);
                    log.info("ids size is "+ids.size());
                    List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(ids);
                    for (IncomeRecord incomeRecord : incomeRecordList) {
                        incomeRecord.setWrId(Constants.DEFAULT_LONG_NONE);
                    }
                    incomeRecordService.updateList(incomeRecordList);
                }


                model.addAttribute("code", 0);

                model.addAttribute("code", 0);
            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("update withdrawRecord error,id is  " + id);
                model.addAttribute("code", -1);

            }
            return "/data/json";
        }
    }

//    @PostConstruct
//    private void initAlipayClient() throws Exception {
//        log.info("alipay init..... ");
//        String url = alipayConfig.get("URL");
//        log.info("url:" + url);
//        String appId = alipayConfig.get("APP_ID");
//        log.info("appId:" + appId);
//        String appPrivateKey = alipayConfig.get("APP_PRIVATE_KEY");
//        log.info("appPrivateKey:" + appPrivateKey);
//
//        String alipayPublicKey = alipayConfig.get("ALIPAY_PUBLIC_KEY");
//        log.info("alipayPublicKey:" + alipayPublicKey);
//
//        String format = alipayConfig.get("FORMAT");
//        log.info("format:" + format);
//
//        String charset = alipayConfig.get("CHARSET");
//        log.info("charset:" + charset);
//
//        String signType = alipayConfig.get("SIGN_TYPE");
//        log.info("signType:" + signType);
//
//        this.alipayClient = new DefaultAlipayClient(url, appId, appPrivateKey, format, charset, alipayPublicKey, signType);
//    }
}

