package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.admin.utils.ObjectConvertUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * @author cjsff
 * @Description :用户
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private CopartnerRelationService copartnerRelationService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private WithdrawRecordService withdrawRecordService;


    /**
     * show 用户列表
     *
     * @param id              用户id
     * @param nick            用户昵称
     * @param mobile          用户手机
     * @param invitationCode  邀请码
     * @param recommendMobile 邀请人手机号
     * @param status          状态
     * @param startTime       注册时间开始
     * @param endTime         注册时间结束
     * @param isVip           是否会员
     * @return 列表
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
    public String getUserIdsByOpenIDJsonList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, Long id, String nick, String mobile, Long startTime, Long endTime, String invitationCode, String recommendMobile, Integer status,Integer isVip) throws Exception {

        log.info("--------------------------search user start-----------------------------------");

        log.info("user search list:" + LogUtil.convertParam("id", id, "nick", nick, "mobile", mobile, "startTime", startTime, "endTime", endTime, "invitationCode",
                invitationCode, "recommendMolibe", recommendMobile, "status", status,"isVip",isVip));
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }

        int start = (page - 1) * size;

        if (start < 0) {
            start = 0;
        }

        Long total = 0L;

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<User> userList = new ArrayList<>();
            List<User> firstRecommend = new ArrayList<>();
            List<UserAsset> userAssetList = new ArrayList<>();
            Map<String, Object> userParams = DynamicUtil.getUserList(id, nick, mobile, invitationCode, recommendMobile, status, startTime, endTime,isVip, false);
            List<Long> userIds = userService.getIdsByDynamicCondition(User.class, userParams, start, size);
            //获取用户
            if (userIds.size() > 0) {
                userList = userService.getObjectsByIds(userIds);
                //获取推荐人信息
                List<Long> recommendIds = MyListUtil.getList(User.class.getDeclaredField("recommendId"), userList);
                if (recommendIds.size() > 0) {
                    firstRecommend = userService.getObjectsByIds(recommendIds);
                }
                //获取用户资产信息
                userAssetList = userAssetService.getObjectsByIds(userIds);
            }


            Map<String, Object> totalParams = DynamicUtil.getUserList(id, nick, mobile, invitationCode, recommendMobile, status, startTime, endTime,isVip, true);
            total = userService.getIdsByDynamicCondition(User.class, totalParams, 0, Integer.MAX_VALUE).get(0);

            log.info("--------------------------search user end-----------------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

            model.addAttribute("userList", userList);
            model.addAttribute("userAssetList", userAssetList);
            model.addAttribute("firstRecommend", firstRecommend);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/userListJson";
    }


    /**
     * show 用户详情
     *
     * @param id 用户id
     * @return 用户信息 用户资产信息
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUserIdsByOpenIDList1(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("-----------------------user details start-----------------------");

        log.info("id is :" + id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        try {
            //用户信息
            User user = userService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(user)) {
                model.addAttribute("code", -1005);
                return "/common/success";
            }
            //用户资产
            UserAsset userAsset = userAssetService.getObjectById(id);
            //上级信息
            User firstRecommend = new User();
            User secondRecommend = new User();
            if (!Constants.DEFAULT_LONG_NONE.equals(user.getRecommendId())) {
                firstRecommend = userService.getObjectById(user.getRecommendId());
                if (!Constants.DEFAULT_LONG_NONE.equals(firstRecommend.getRecommendId())) {
                    secondRecommend = userService.getObjectById(firstRecommend.getRecommendId());
                }
            }
            //下级/下下级合伙人列表
            List<Long> copartnerrelationIds = copartnerRelationService.getCopartnerRelationIdsByUidOrderByCreateAt(user.getId(), 0, Integer.MAX_VALUE);
            List<CopartnerRelation> copartnerRelationList = new ArrayList<>();
            if (copartnerrelationIds.size() > 0) {
                copartnerRelationList = copartnerRelationService.getObjectsByIds(copartnerrelationIds);
            }
            Map<Integer, List<CopartnerRelation>> copartnerMap = MyListUtil.convert2ListMap(CopartnerRelation.class.getDeclaredField("level"), copartnerRelationList);
            //下级合伙人id
            log.info("copartnerMap is" + copartnerMap);
            List<CopartnerRelation> fcr = copartnerMap.get(CopartnerRelation.LEVEL_FIRST);

            List<Long> fuids = MyListUtil.getList(CopartnerRelation.class.getDeclaredField("subUid"), fcr);
            List<User> firstCopartnerList = userService.getObjectsByIds(fuids);
            log.info("firstCopartnerList size is " + firstCopartnerList.size());
            //下级合伙人收入
            Map<String, Object> fmap = DynamicUtil.getSumAmountByUidAndLevel(id, IncomeRecord.LEVEL_FIRST);
            Object fresult = incomeRecordService.getObjectByDynamicCondition(IncomeRecord.class, fmap, 0, Integer.MAX_VALUE);

            List<Object[]> fAmount = (List<Object[]>) ObjectConvertUtil.objectToArrayList(fresult);
            log.info("fAmount size is " + fAmount.size());
            //下下级合伙人id
            List<CopartnerRelation> scr = copartnerMap.get(CopartnerRelation.LEVEL_SECOND);
            List<Long> suids = MyListUtil.getList(CopartnerRelation.class.getDeclaredField("subUid"), scr);
            List<User> secondCopartnerList = userService.getObjectsByIds(suids);
            log.info("secondCopartnerList size is " + secondCopartnerList.size());

            //下下级合伙人收入
            Map<String, Object> smap = DynamicUtil.getSumAmountByUidAndLevel(id, IncomeRecord.LEVEL_SECOND);
            Object sresult = incomeRecordService.getObjectByDynamicCondition(IncomeRecord.class, smap, 0, Integer.MAX_VALUE);
            ;
            List<Object[]> sAmount = (List<Object[]>) ObjectConvertUtil.objectToArrayList(sresult);
            log.info("sAmount size is " + sAmount.size());
            model.addAttribute("user", user);
            model.addAttribute("userAsset", userAsset);
            model.addAttribute("firstRecommend", firstRecommend);
            model.addAttribute("secondRecommend", secondRecommend);

            model.addAttribute("secondCopartnerList", secondCopartnerList);
            model.addAttribute("firstCopartnerList", firstCopartnerList);
            model.addAttribute("fAmount", fAmount);
            model.addAttribute("sAmount", sAmount);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/userDetailJson";
    }


    /**
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     * @Description:修改用户账号状态
     */
    @RequestMapping(value = "/a/u/user/{id}/status", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {

        log.info("-------------------update user status start-----------------------");

        log.info("id is :" + id + ",status is :" + status);
        Manager manager = (Manager) request.getAttribute("manager");
        if (DataUtils.isNullOrEmpty(status)) {
            log.info("status is null");
            model.addAttribute("code", -5055);
            return "/common/success";
        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -1000);

                return "/common/success";
            }
            if (!user.getStatus().equals(status)){
                user.setStatus(status);
                user.setUpdateBy(manager.getId());
                userService.update(user);
            }
            log.info("-------------------update user status end-----------------------");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }


    /**
     * show 設置vip
     * @param id 用戶id
     * @return 操作結果
     * @throws Exception exception
     */
    @RequestMapping(value = "/a/u/user/{id}/vip", method = RequestMethod.PUT)
    public String updateUserVip(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("-------------------update user vip start-----------------------");

        log.info("id is :" + id );
        Manager manager = (Manager) request.getAttribute("manager");

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -1000);

                return "/common/success";
            }
            if (user.getIsVip().equals(User.IS_VIP_TRUE)) {
                log.info("user is already vip");
                model.addAttribute("code", -3023);
                return "/common/success";
            } else if (!Constants.DEFAULT_LONG_NONE.equals(user.getTeamUid())) {
                log.info("user belong team of vip ");
                model.addAttribute("code", -3026);
                return "/common/success";
            } else {
                user.setIsVip(User.IS_VIP_TRUE);
                user.setVipAt(System.currentTimeMillis());
            }
            user.setUpdateBy(manager.getId());
            log.info("vip id:"+id+" manager:"+manager);


            //清空上级关系
            log.info("clear the superior partner relationship...");
            List<UserAsset> assetList = new ArrayList<>();
            List<Long> cids = copartnerRelationService.getCopartnerRelationIdsBySubUid(id, 0, Integer.MAX_VALUE);
            List<CopartnerRelation> copartnerRelationList = copartnerRelationService.getObjectsByIds(cids);
            log.info("copartnerRelationList size is "+copartnerRelationList.size());
            for (CopartnerRelation copartnerRelation : copartnerRelationList) {
                copartnerRelation.setStatus(CopartnerRelation.STATUS_DISABLE);

                Long uid = copartnerRelation.getUid();
                Integer level = copartnerRelation.getLevel();
                log.info("uid="+uid+" ,level="+level);

                //修改上級合伙人的合伙人数量
                log.info("update partner asset");
                UserAsset userAsset = userAssetService.getObjectById(uid);
                Integer count;
                if (level.equals(CopartnerRelation.LEVEL_FIRST)) {
                    count = userAsset.getFirstCoprtnerCount();
                    log.info("FirstCoprtnerCount: "+count +"-->" + (count-1));
                    userAsset.setFirstCoprtnerCount(count-1);
                } else if (level.equals(CopartnerRelation.LEVEL_SECOND)) {
                    count = userAsset.getSecondCoprtnerCount();
                    log.info("SecondCoprtnerCount: "+count +"-->" + (count-1));
                    userAsset.setFirstCoprtnerCount(count-1);
                }
                assetList.add(userAsset);
            }

            //修改用户资产信息
            log.info("update user asset");
            UserAsset userAsset = userAssetService.getObjectById(id);
            userAsset.setApplyingAmount(BigDecimal.ZERO);
            userAsset.setCopartnerAmount(BigDecimal.ZERO);
            userAsset.setSurplusAmount(BigDecimal.ZERO);
            userAsset.setTodayAmount(BigDecimal.ZERO);
            userAsset.setRebateAmount(BigDecimal.ZERO);

            assetList.add(userAsset);

            userAssetService.updateList(assetList);
            log.info("asset update success");
            copartnerRelationService.updateList(copartnerRelationList);
            log.info("copartner relation update success");

            //清理用户收入记录
            //1返佣 2合伙人
            Map<String,Object> map=DynamicUtil.getUserIncomeRecordByType("1,2", id);
            List<Long> incomeIds = incomeRecordService.getIdsByDynamicCondition(IncomeRecord.class,map,0,Integer.MAX_VALUE);
            if (!incomeIds.isEmpty()){
                List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(incomeIds);
                for (IncomeRecord incomeRecord : incomeRecordList) {
                    incomeRecord.setStatus(Constants.DEFAULT_INT_NONE);
                }
                incomeRecordService.updateList(incomeRecordList);
                log.info("income record update success");
            }
            //清理用户提现记录
            List<Long> withdrawIds=withdrawRecordService.getWithdrawRecordIdsByUidOrderByCreateAt(id, 0, Integer.MAX_VALUE);

            if (!withdrawIds.isEmpty()){
                List<WithdrawRecord> withdrawRecordList = withdrawRecordService.getObjectsByIds(withdrawIds);
                for (WithdrawRecord withdrawRecord : withdrawRecordList) {
                    withdrawRecord.setStatus(Constants.DEFAULT_INT_NONE);
                }
                withdrawRecordService.updateList(withdrawRecordList);
                log.info("withdraw record update success");
            }
            //除掉用戶邀請人
            user.setRecommendId(Constants.DEFAULT_LONG_NONE);
            user.setTeamUid(Constants.DEFAULT_LONG_NONE);
            user.setLevel(0);
            userService.update(user);
            log.info("-------------------update user vip end-----------------------");


            log.info("Recursively all subordinate user ids");
            List<Long> teamUserIds = new ArrayList<>();
            List<Long> nextLevelIds = new ArrayList<>();
            List<Long> vipIds = new ArrayList<>();
            vipIds.add(id);
            nextLevelIds=getTeamUserIds(vipIds);
            //下级ids不为空则开始递归
            while (!nextLevelIds.isEmpty()) {
                log.info("nextLevel ids size is "+nextLevelIds.size());
                //所有下级信息加到团队列表里
                teamUserIds.addAll(nextLevelIds);
                log.info("teamUserIds ids size is "+teamUserIds.size());
                //用下级ids再查找下级信息
                nextLevelIds=getTeamUserIds(nextLevelIds);
            }
            log.info("Recursively all subordinate user ids done ,size is "+teamUserIds.size());

            //重置level等级
            resetLevel(id);

            //更新团队用户信息
            if (!teamUserIds.isEmpty()){
                Map <String,Object> updateMap=DynamicUtil.updateUsersTeamUid(teamUserIds, id);
                userService.getObjectByDynamicCondition(User.class, updateMap, 0, Integer.MAX_VALUE);
                log.info("team uid update success");
                Map <String,Object> updateMap2=DynamicUtil.updateUsersVipAt(teamUserIds);
                userService.getObjectByDynamicCondition(User.class, updateMap2, 0, Integer.MAX_VALUE);
                log.info("team vip_at update success");
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }
    /**
     * show 找出所有该用户下级id
     * @param uids 用户 ids
     * @return java.util.List<java.lang.Long>
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/9/28
     */
    private List<Long> getTeamUserIds (List<Long> uids) throws Exception {
        Map<String, Object> map = DynamicUtil.getTeamAllUserIds(uids);
        return userService.getIdsByDynamicCondition(User.class, map, 0, Integer.MAX_VALUE);
    }







    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id, String mobile, Integer status) throws Exception {

        log.info("------------------------update user start------------------------");

        log.info("id is :" + id + ",mobile is :" + mobile + ",status is :" + status);
        Manager manager = (Manager) request.getAttribute("manager");
        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -1000);

                return "/common/success";
            }
            if (DataUtils.isNotNullOrEmpty(mobile)) {
                user.setMobile(mobile);
                user.setUpdateBy(manager.getId());
                log.info("user id=" + id + " mobile is change to " + mobile + " , manager=" + manager.getId());
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                user.setStatus(status);
            }
            userService.update(user);
            log.info("------------------------update user end------------------------");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }



    /**
     * show vip信息列表
     *
     * @param query           查微信昵称、手机号、邀请码
     * @param startAt         起始时间
     * @param endAt           结束时间
     * @return 列表
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/vip/search", method = RequestMethod.GET)
    public String getVipList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, String query,Long startAt ,Long endAt) throws Exception {

        log.info("--------------------------search user start-----------------------------------");

        log.info("vip search list:" + LogUtil.convertParam("query", query, "startAt", startAt, "endAt", endAt));
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }

        int start = (page - 1) * size;

        if (start < 0) {
            start = 0;
        }

        int total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Manager manager = (Manager) request.getAttribute("manager");
            List<User> vipList = new ArrayList<>();
            List<Object[]> statisticsList = new ArrayList<>();

            Long uid = null;
            if (Manager.IS_VIP_TRUE.equals(manager.getIsVip())) {
                uid = userService.getUserIdByMobile(manager.getMobile());
                if (DataUtils.isNullOrEmpty(uid)) {
                    model.addAttribute("code", -3024);
                    return "/common/success";
                }
                User vip = userService.getObjectById(uid);
                //团队返佣收入
                List<Long> ids = new ArrayList<>();
                ids.add(uid);
                Map<String,Object> rebateAmountMap =DynamicUtil.getVipTeamAmount(ids,startAt,endAt,"1");
                Object teamRebateResult  =  userService.getObjectByDynamicCondition(User.class, rebateAmountMap, 0, Integer.MAX_VALUE);
                List<Object[]> teamRebate = (List<Object[]>) ObjectConvertUtil.objectToArrayList(teamRebateResult);
                teamRebate=ObjectConvertUtil.dataPadding(teamRebate,ids,0);
                //团队毛利
                Map<String,Object> teamProfitAmountMap =DynamicUtil.getTeamGrossProfit(ids,startAt,endAt);
                Object teamProfitResult =  userService.getObjectByDynamicCondition(User.class, teamProfitAmountMap, 0, Integer.MAX_VALUE);
                List<Object[]> teamProfit = (List<Object[]>) ObjectConvertUtil.objectToArrayList(teamProfitResult);
                teamProfit=ObjectConvertUtil.dataPadding(teamProfit,ids,0);

                //团队收入
                Map<String,Object> amountMap =DynamicUtil.getVipTeamAmount(ids,startAt,endAt,"1,2");
                Object teamIncomeResult  =  userService.getObjectByDynamicCondition(User.class, amountMap, 0, Integer.MAX_VALUE);
                List<Object[]> teamIncome = (List<Object[]>) ObjectConvertUtil.objectToArrayList(teamIncomeResult);
                teamIncome=ObjectConvertUtil.dataPadding(teamIncome,ids,0);

                //团队人数
                Map<String,Object> memberMap =DynamicUtil.getVipTeamMemberList(uid,endAt);
                List<Long> memberIds = userService.getIdsByDynamicCondition(User.class, memberMap, 0, Integer.MAX_VALUE);
                Integer memberCount = memberIds.size();
                model.addAttribute("vip", vip);
                model.addAttribute("teamRebate", teamRebate.get(0)[1]);
                model.addAttribute("teamProfit", teamProfit.get(0)[1]);
                model.addAttribute("teamIncome", teamIncome.get(0)[1]);
                model.addAttribute("memberCount", memberCount);
            }
            //vip列表
            List<Long> vipIds = userService.getIdsByDynamicCondition(User.class, DynamicUtil.getVipUserList(query,uid), start, size);
            total = userService.getIdsByDynamicCondition(User.class, DynamicUtil.getVipUserList(query,uid), 0, Integer.MAX_VALUE).size();
            vipList = userService.getObjectsByIds(vipIds);

            //列表团队毛利收入
            Map<String,Object> teamProfitMap =DynamicUtil.getTeamGrossProfit(vipIds,startAt,endAt);
            Object teamProfitResult  =  userService.getObjectByDynamicCondition(User.class, teamProfitMap, 0, Integer.MAX_VALUE);
            List<Object[]> teamProfitList = (List<Object[]>) ObjectConvertUtil.objectToArrayList(teamProfitResult);
            teamProfitList=ObjectConvertUtil.dataPadding(teamProfitList,vipIds,0);

            //团队人数统计信息
            Map<String,Object> memberCountMap=DynamicUtil.getVipTeamMemberCount(vipIds,endAt);
            Object memberCountObject  =  userService.getObjectByDynamicCondition(User.class, memberCountMap, 0, Integer.MAX_VALUE);
            List<Object[]> memberCountList = (List<Object[]>) ObjectConvertUtil.objectToArrayList(memberCountObject);
            memberCountList=ObjectConvertUtil.dataPadding(memberCountList,vipIds,0);
            log.info("memberCountList="+memberCountList);
            log.info("--------------------------vip user end-----------------------------------");

            model.addAttribute("teamProfitList", teamProfitList);
            model.addAttribute("memberCountList", memberCountList);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("vipList", vipList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/vipListJson";
    }



    /**
     * show vip团队详情
     *
     * @param query           查微信昵称、手机号、邀请码
     * @param createAtStart   起始时间
     * @param createAtEnd     结束时间
     * @param uid             uid
     * @param level           级别
     * @return 列表
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/team/{uid}/search", method = RequestMethod.GET)
    public String getTeamList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, String query,Long createAtStart ,Long createAtEnd ,Integer level,@PathVariable Long uid) throws Exception {

        log.info("--------------------------search user start-----------------------------------");

        log.info("team search list:" + LogUtil.convertParam("level", level,"uid", uid, "query", query, "createAtStart", createAtStart, "createAtEnd", createAtEnd));
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }

        int start = (page - 1) * size;

        if (start < 0) {
            start = 0;
        }

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<User> userList = new ArrayList<>();
//            List<User> firstRecommend = new ArrayList<>();
            List<UserAsset> userAssetList = new ArrayList<>();
            Map<String, Object> userParams = DynamicUtil.getTeamMemberSearch(uid,createAtStart,createAtEnd,query,level);
            List<Long> userIds = userService.getIdsByDynamicCondition(User.class, userParams, start, size);
            total = userService.getIdsByDynamicCondition(User.class, userParams, 0, Integer.MAX_VALUE).size();
            //获取用户
            if (userIds.size() > 0) {
                userList = userService.getObjectsByIds(userIds);
                //获取用户资产信息
                userAssetList = userAssetService.getObjectsByIds(userIds);
            }

            log.info("--------------------------vip user end-----------------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

            model.addAttribute("userList", userList);
            model.addAttribute("userAssetList", userAssetList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/teamListJson";
    }


    /**
     * 重置level排序
     *
     * @param uid   vip团队id
     * @return 列表
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/reset/level", method = RequestMethod.PUT)
    public String restL(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model,Long uid ) throws Exception {

        log.info("--------------------------reset level-----------------------------------");
        try {
            resetLevel(uid);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    private void resetLevel (Long uid) throws Exception{
        //找出第一级代理
        log.info("Recursively all subordinate user ids");
        List<Long> nextLevelIds = new ArrayList<>();
        List<Long> vipIds = new ArrayList<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            vipIds.add(uid);
        }
        nextLevelIds=getTeamUserIds(vipIds);
        int level = 1;
        //下级ids不为空则开始递归
        while (!nextLevelIds.isEmpty()) {
            //设置level
            log.info("current level is "+level);
            userService.getObjectByDynamicCondition(User.class, DynamicUtil.updateDataByTableAndFieldAndValue("user", "level", String.valueOf(level), "id in (" + StringUtils.join(nextLevelIds, ",") + ")"), 0, Integer.MAX_VALUE);
//            if (DataUtils.isNotNullOrEmpty(uid)) {
//                userService.getObjectByDynamicCondition(User.class, DynamicUtil.updateDataByTableAndFieldAndValue("user", "team_uid", uid.toString(), "id in (" + StringUtils.join(nextLevelIds, ",") + ")"), 0, Integer.MAX_VALUE);
//            }
            level++;
            log.info("nextLevel ids size is "+nextLevelIds.size() + " level="+level);
            //用下级ids再查找下级信息
            nextLevelIds=getTeamUserIds(nextLevelIds);
        }
    }
}

