package com.ptteng.keeper.admin.utils;

import com.csvreader.CsvReader;
import com.gemantic.common.util.PasswordUtils;

import com.ptteng.keeper.common.model.ApplyingRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import static com.ptteng.keeper.admin.utils.ParseExcel.*;

//import com.ptteng.haichuan.audit.model.Inventory;

/**
 * 解析盘库和倒查csv文件
 *
 * @author liut
 */
public class ParseCSV {


    private static final Log log = LogFactory.getLog(ParseCSV.class);

    /**
     * 私有化构造器
     */
    private ParseCSV() {
    }

    /**
     * 解析盘库csv文件
     *
     * @param inventoryUrl
     * @return
     */
    public static List<ApplyingRecord> parseUserCSV(String inventoryUrl) {
        List<ApplyingRecord> list = new ArrayList<>();
        if (StringUtils.isEmpty(inventoryUrl)) {
            log.info("arg inventoryUrl is empty");
            return list;
        }
        CsvReader reader = null;
        try {
            reader = new CsvReader(getExcelFilePath(inventoryUrl), ',', Charset.forName("GBK"));
            reader.readHeaders(); // 跳过表头

            ApplyingRecord applyingRecord = null;
            String[] values = null;
            String cur = null;
            while (reader.readRecord()) { // 遍历表体中的数据
                applyingRecord = new ApplyingRecord();
                values = reader.getValues();
                for (int i = 0; i < values.length; i++) {
                    cur = values[i];
                    if (i == inventory_colums[0]) {
                        //设置年级
                        log.info("手机：" + cur + "----->" + Integer.valueOf(cur));
//            user.setGrade(Integer.valueOf(cur));
                    } else if (i == inventory_colums[1]) {
                        //设置班级
                        log.info("班级：" + cur);
//            user.setClassName(cur);
                    } else if (i == inventory_colums[2]) {
                        //设置姓名
                        log.info("姓名：" + cur);
//            user.setAlias(cur);
                    } else if (i == inventory_colums[3]) {
                        //设置手机
                        log.info("手机：" + cur);
//            user.setMobile(cur);
                    } else if (i == inventory_colums[4]) {
                        //设置邮件
                        log.info("邮件：" + cur);
//            user.setMail(cur);
                    } else if (i == inventory_colums[5]) {
                        //设置密码;
                        log.info("密码：" + cur);
                        String encodePass = PasswordUtils.encode("000000");
                        if (cur != null) {
                            encodePass = PasswordUtils.encode(cur);
                        }
//            user.setPwd(encodePass);
                    } else {
                        continue;
                    }
                }
                list.add(applyingRecord);
            }
        } catch (Exception e) {
            log.error("parseInventoryCSV error...", e);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return list;
    }


}
