package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.admin.utils.ObjectConvertUtil;
import com.ptteng.keeper.admin.utils.ParseExcel;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.*;

/**
 * ApplyingRecord  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ApplyingRecordController {
    private static final Log log = LogFactory.getLog(ApplyingRecordController.class);

    @Autowired
    private ApplyingRecordService applyingRecordService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductService productService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private ManagerService managerService;
    /**
     * 无需修改名字的文件尾缀，<b>必须有序存放</b> <br>
     * 例如："apk" < "jpeg" < "jpg"
     */
    private static final String[] suffixs = {"apk", "jpeg", "jpg", "png"};

    /**
     * 文件上传接口，包括图片，excel，apk等文件
     *
     * @param request
     * @param response
     * @param model
     * @param file
     * @param module
     * @return
     */
    @RequestMapping(value = "/a/u/file/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) {
        log.info("controller uploadFile begin...");
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        log.info("argument module is: " + module + ", file name is: " + file.getOriginalFilename());
        try {
            /* 第一步、文件上传前的准备工作 */
            long size = file.getSize();
            log.info("upload file size is: " + size + " bytes");
            String suffix = FileUtil.getFileExtension(file.getOriginalFilename());
            log.info("upload file suffix is: " + suffix);
            String newFileName, oldFileName = file.getOriginalFilename();
            if (Arrays.binarySearch(suffixs, suffix) >= 0) { // include
                newFileName = oldFileName;
            } else {
                newFileName = UUID.randomUUID().toString() + "." + suffix;
            }
            log.info("the newFileName is: " + newFileName);

            /* 第二步、上传文件 */
            /* 临时目录 */
            String tempDirStr = ParseExcel.FILE_PATH + "/" + module;
            log.info("tempDirStr is: " + tempDirStr);
            File tempDir = new File(tempDirStr);
            if (tempDir.exists()) {
                log.info("temp dir has exists, do not need to mkdir");
            } else {
                log.info("temp dir not exists");
                tempDir.mkdirs();
            }
            /* 临时文件 */
            String tempFileStr = tempDirStr + "/" + newFileName;
            log.info("tempFileStr is: " + tempFileStr);
            File tempFile = new File(tempFileStr);
            if (tempFile.exists()) {
                log.info("temp file has exists, do not need to touch");
            } else {
                log.info("temp file not exists");
                tempFile.createNewFile();
            }
            file.transferTo(tempFile);
            String url;

            /* 第三步、分情况上传并删除临时文件 */
            if (ParseExcel.EXCEL_SUFFIX[0].equals(suffix) || ParseExcel.EXCEL_SUFFIX[1].equals(suffix)
                    || ParseExcel.EXCEL_SUFFIX[2].equals(suffix)) {
                log.info("excel file need to parse, temporarily not to delete");
                url = tempFileStr;
            } else {
                url = imgStorageUtil.imgStorage(module, module + "/" + newFileName, tempFileStr);
                log.info("upload success, and new file name is: " + newFileName
                        + ", and new file temp dir is: " + tempDirStr + ", and access url is: " + url);
                log.info("other file need to delete");
                tempFile.delete();
                log.info(oldFileName + " delete success");
            }
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error("uploadFile error...", t);
            model.addAttribute("code", -1);
            return "/common/img";
        }
        log.info("controller uploadFile end...");
        return "/common/img";
    }

    /**
     * show 申请列表
     *
     * @param id          申请id
     * @param mobile      手机号
     * @param proxyMobile 代理人手机号
     * @param productName 产品名
     * @param name        姓名
     * @param idCard      身份证
     * @param status      状态
     * @param startTime   申请时间开始
     * @param endTime     申请时间结束
     * @param excelPath   excel地址
     * @return applyingRecord user product
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/apply/search", method = RequestMethod.GET)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, Integer page,
                                                                            Integer size, Long id, String mobile, String proxyMobile, String name, String idCard, String productName, Integer status, Long startTime, Long endTime, String excelPath) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);
        log.info("apply search: " + LogUtil.convertParam("id", id, "mobile", mobile, "proxyMobile", proxyMobile, "productName", productName,
                "name", name, "idCard", idCard, "status", status, "startTime", startTime, "endTime", endTime, "excelPath", excelPath));
        try {
            List<ApplyingRecord> applyingRecordList = new ArrayList<>();
            List<Product> productList = new ArrayList<>();
            List<User> userList = new ArrayList<>();
            BigInteger total = BigInteger.ZERO;
            //EXCEL表搜索
            if (DataUtils.isNotNullOrEmpty(excelPath)) {
                Map<String, List<BigDecimal>> omap = new HashMap<>();
                Map<String, Object> map = ParseExcel.excelToSqlMap(excelPath, omap);
                log.info(omap);
                List<Long> arIds = applyingRecordService.getIdsByDynamicCondition(ApplyingRecord.class, map, start, size);
                List<Long> totalIds = applyingRecordService.getIdsByDynamicCondition(ApplyingRecord.class, map, 0, Integer.MAX_VALUE);
                log.info("arids size is "+arIds.size());
                if (arIds.size() > 0) {
                    applyingRecordList = applyingRecordService.getObjectsByIds(arIds);
                    log.info("result size is "+applyingRecordList.size());
                    //金额填充
                    List<ApplyingRecord> updateList = new ArrayList<>();
                    total = new BigInteger(String.valueOf(totalIds.size()));
                    String lastKey = "";
                    for (int i = 0,idx=0, len = arIds.size(); i < len; i++) {
                        ApplyingRecord applyingRecord = applyingRecordList.get(i);
                        String key = ParseExcel.getKey(applyingRecord.getMobile(), applyingRecord.getProductId().toString());
                        List<BigDecimal> bigDecimalList = omap.get(key);
                        log.info("key is " + key + ", amount is" + bigDecimalList);
                        //只操作申请中的
                        if (applyingRecord.getStatus().equals(ApplyingRecord.STATUS_APPLYING)) {
                            //判断重复内容赋值,如果有重复的，利用idx自增，每次取不同的值进行赋值，直到取到取到下一个不同的key后重置
                            if (!lastKey.equals(key)) {
                                log.info("idx 重置");
                                idx = 0;
                            }
                            if (idx+1>bigDecimalList.size()){
                                continue;
                            }
                            log.info("=====开始取第"+idx+"个值 ，值为===="+bigDecimalList.get(idx));
                            applyingRecord.setVerifyAmount(bigDecimalList.get(idx));
                            idx++;
                            log.info("set id=" + applyingRecord.getId() + "record verifyAmount=" + omap.get(key));
                            updateList.add(applyingRecord);
                        } else {
                            log.info("this record status is not applying");
                        }
                        lastKey = key;
                    }
                    applyingRecordService.updateList(updateList);
                    log.info("update list success, size is " + updateList.size());
                }
            } else {
                Map<String, Object> map = DynamicUtil.getApplyingRecordList(id, name, mobile, proxyMobile, productName, idCard, startTime, endTime, status, false);
                Map<String, Object> totalMap = DynamicUtil.getApplyingRecordList(id, name, mobile, proxyMobile, productName, idCard, startTime, endTime, status, true);

                List<Long> arIds = applyingRecordService.getIdsByDynamicCondition(ApplyingRecord.class, map, start, size);
                if (arIds.size() > 0) {
                    applyingRecordList = applyingRecordService.getObjectsByIds(arIds);
                    log.info("arIds size= " + arIds.size());
                    total = (BigInteger) applyingRecordService.getObjectByDynamicCondition(ApplyingRecord.class, totalMap, 0, Integer.MAX_VALUE);
                }
            }

            List<Long> uids = MyListUtil.getList(ApplyingRecord.class.getDeclaredField("createBy"), applyingRecordList);
            userList = userService.getObjectsByIds(uids);
            log.info("uids size= " + uids.size());

            List<Long> pids = MyListUtil.getList(ApplyingRecord.class.getDeclaredField("productId"), applyingRecordList);
            productList = productService.getObjectsByIds(pids);
            log.info("pids size= " + pids.size());

            List<Long> mids = MyListUtil.getList(ApplyingRecord.class.getDeclaredField("updateBy"), applyingRecordList);
            List<Manager> managerList= managerService.getObjectsByIds(mids);
            log.info("mids size= " + mids.size());


            log.info("total=" + total);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("applyingRecordList", applyingRecordList);
            model.addAttribute("userList", userList);
            model.addAttribute("productList", productList);
            model.addAttribute("managerList", managerList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/applyingRecord/json/applyingUserProductListJson";
    }


    /**
     * show 待核账产品列表
     *
     * @return product conut
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/apply/pending", method = RequestMethod.GET)
    public String getApplyingRecordIdsByMobileOrderByCreateAtJsonList(HttpServletRequest request,
                                                                      HttpServletResponse response, ModelMap model) throws Exception {


        log.info("get apply pending list");

        try {
            Map<String, Object> map = DynamicUtil.getApplyingPendingProductList(ApplyingRecord.STATUS_APPLYING, null);
            Object result = applyingRecordService.getObjectByDynamicCondition(ApplyingRecord.class, map, 0, Integer.MAX_VALUE);
            List<Object[]> resultList = (List<Object[]>) ObjectConvertUtil.objectToArrayList(result);
            log.info("sAmount size is " + resultList.size());
            model.addAttribute("code", 0);
            model.addAttribute("resultList", resultList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get applyingRecord list error,page is");
            // for test
            model.addAttribute("code", -1);
        }

        return "/keeper/product/json/productAndCountListJson";
    }


    /**
     * show 添加核账金额
     *
     * @param id           applyRecord id
     * @param verifyAmount 核账金额
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/apply/{id}/amount", method = RequestMethod.PUT)
    public String updateApplyVerifyAmount(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long id, BigDecimal verifyAmount)
            throws Exception {

        log.info("updateApplyVerifyAmount : id= " + id + " ,verifyAmount=" + verifyAmount);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(verifyAmount) ||BigDecimal.ZERO.compareTo(verifyAmount) > 0) {
            model.addAttribute("code", -5002);
            return "/common/success";
        }

        try {
            ApplyingRecord applyingRecord = applyingRecordService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(applyingRecord)) {
                model.addAttribute("code", -1005);
                return "/common/success";
            }
            applyingRecord.setVerifyAmount(verifyAmount);
            applyingRecordService.update(applyingRecord);
            log.info("update applyingRecord success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get applyingRecord error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * show 核账操作
     *
     * @param id     申请单id
     * @param status 状态
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/apply/{id}/status", method = RequestMethod.PUT)
    public String updateApplyingRecordJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {
        synchronized (this) {
            log.info("update applyingRecord  status: id=" + id + " ,status=" + status);
            if (DataUtils.isNullOrEmpty(id)) {
                model.addAttribute("code", -1100);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(status)) {
                model.addAttribute("code", -2002);
                return "/common/success";
            }
            try {
                Manager manager = (Manager) request.getAttribute("manager");
                ApplyingRecord applyingRecord = applyingRecordService.getObjectById(id);
                if (DataUtils.isNullOrEmpty(applyingRecord)) {
                    model.addAttribute("code", -1005);
                    return "/common/success";
                }

                //校验状态
                if (!ApplyingRecord.STATUS_APPLYING.equals(applyingRecord.getStatus())) {
                    log.info("apply status="+applyingRecord.getStatus());
                    model.addAttribute("code", -5001);
                    return "/common/success";
                }
                //驳回操作
                if (ApplyingRecord.STATUS_REJECT.equals(status)) {
                    applyingRecord.setStatus(status);
                    applyingRecord.setUpdateBy(manager.getId());
                    applyingRecordService.update(applyingRecord);

                }
                //同意核账操作
                /*
                 *此处计算的基值为管理员输入的核账金额
                 *这里填的数据分两种情况；一种申请人申请的金额，一种是返佣金额
                 *如何判断是哪种，根据网贷产品创建时，给的是比例，还是金额。
                 *是比例，那么这个填的金额是申请人申请的金额；是金额，那么填的金额就是返佣金额
                 *比例：
                 **---20.7.08.21废弃 如果申请人申请了5000，返佣比例是3%，那么代理收益=5000*3%-上级代理比例*150-上上级代理比例*150
                 * 金额：
                 *
                 *---20.7.08.21废弃-- 如果申请人申请了5000，返佣金额是100，那么代理收益=100-上级代理比例*100-上上级代理比例*100
                 *---20.7.08.21新-- 如果申请人申请了5000，返佣金额是100，那么代理收益=100
                 *
                 ***/
                if (ApplyingRecord.STATUS_AGREE.equals(status)) {
                    List<IncomeRecord> incomeRecordList = new ArrayList<>();
                    List<UserAsset> userAssetList = new ArrayList<>();
                    StringBuilder stringBuilder = new StringBuilder();
                    applyingRecord.setUpdateBy(manager.getId());
                    //结算金额
                    BigDecimal verifyAmount = applyingRecord.getVerifyAmount();
                    log.info("verifyAmount=" + verifyAmount);
                    //判断核账金额的值 为 -1则是没有填写
                    if (BigDecimal.valueOf(-1).compareTo(verifyAmount) == 0) {
                        model.addAttribute("code", -5002);
                        return "/common/success";
                    }
                    applyingRecord.setStatus(status);

                    //如果没有代理人，则不计算，直接通过
                    Long agentId = applyingRecord.getCreateBy();
                    if (Constants.DEFAULT_LONG_NONE.equals(agentId)) {
                        applyingRecordService.update(applyingRecord);
                        log.info("update apply record status success");
                        model.addAttribute("code", 0);
                        return "/common/success";
                    }
                    User agent = userService.getObjectById(agentId);
                    User firstAgent = null;
                    User secondAgent = null;
                    //上级代理人
                    Long firstAgentId = agent.getRecommendId();
                    boolean hasFirst = false;
                    boolean hasSecond = false;
                    if (Constants.DEFAULT_LONG_NONE.equals(firstAgentId)) {
                        log.info("firstAgent does not exist");
                    } else {
                        firstAgent = userService.getObjectById(firstAgentId);
                        hasFirst = true;
                        if (Constants.DEFAULT_LONG_NONE.equals(firstAgent.getRecommendId())) {
                            log.info("firstAgent does not exist");
                        } else {
                            secondAgent = userService.getObjectById(firstAgent.getRecommendId());
                            hasSecond = true;
                        }
                    }

                    //判断产品返佣类型,根据类型进行计算
                    Product product = productService.getObjectById(applyingRecord.getProductId());
                    //返佣类型
                    Integer rebateMode = product.getRebateMode();
                    log.info("rebateMode=" + rebateMode);
                    //比例模式 比例需要除以100
                    if (Product.REBATE_MODE_RATE.equals(rebateMode)) {
                        //返佣比例
                        BigDecimal rebateRate = product.getRebateNum().divide(BigDecimal.valueOf(100), 10, BigDecimal.ROUND_HALF_UP);
                        log.info("rebateRate=" + rebateRate);
                        //佣金 = 申请人申请的金额X比例=佣金
                        BigDecimal rebateAmount = verifyAmount.multiply(rebateRate);
                        log.info("rebateAmount=verifyAmount*rebateRate---> " + rebateAmount);
                        //代理人收入
                        updateCopartnerInfo(model, applyingRecord, incomeRecordList, userAssetList, stringBuilder, rebateAmount, agentId, secondAgent, firstAgentId, hasFirst, hasSecond, product, rebateAmount);
                        applyingRecord.setProxyAmount(rebateAmount);
                        //创建代理人收入记录
                        IncomeRecord agentIncomeRecord = new IncomeRecord();
                        agentIncomeRecord.setProductId(applyingRecord.getProductId());
                        agentIncomeRecord.setType(IncomeRecord.TYPE_REBATE);
                        agentIncomeRecord.setLevel(IncomeRecord.LEVEL_ZORE);
                        agentIncomeRecord.setAmount(rebateAmount);
                        agentIncomeRecord.setTargetId(applyingRecord.getId());
                        agentIncomeRecord.setUid(agentId);
                        agentIncomeRecord.setCreateBy(agentId);
                        agentIncomeRecord.setUpdateBy(agentId);
                        incomeRecordList.add(agentIncomeRecord);
                        stringBuilder.append(agentId);
                        //代理人资产更新
                        UserAsset agentUserAsset = updateUserAsset(agentIncomeRecord, model);
                        userAssetList.add(agentUserAsset);
                    }                //比例模式 比例需要除以100
                    //金额模式
                    if (Product.REBATE_MODE_AMOUNT.equals(rebateMode)) {
                        //佣金 = 核算金额
                        log.info("rebateAmount=" + verifyAmount);
                        //代理人收入
                        updateCopartnerInfo(model, applyingRecord, incomeRecordList, userAssetList, stringBuilder, verifyAmount, agentId, secondAgent, firstAgentId, hasFirst, hasSecond, product, verifyAmount);
                        applyingRecord.setProxyAmount(verifyAmount);
                        //创建代理人收入记录
                        IncomeRecord agentIncomeRecord = new IncomeRecord();
                        agentIncomeRecord.setProductId(applyingRecord.getProductId());
                        agentIncomeRecord.setType(IncomeRecord.TYPE_REBATE);
                        agentIncomeRecord.setLevel(IncomeRecord.LEVEL_ZORE);
                        agentIncomeRecord.setAmount(verifyAmount);
                        agentIncomeRecord.setTargetId(applyingRecord.getId());
                        agentIncomeRecord.setUid(agentId);
                        agentIncomeRecord.setCreateBy(agentId);
                        agentIncomeRecord.setUpdateBy(agentId);
                        incomeRecordList.add(agentIncomeRecord);
                        stringBuilder.append(agentId);
                        //代理人资产更新
                        UserAsset agentUserAsset = updateUserAsset(agentIncomeRecord, model);
                        userAssetList.add(agentUserAsset);
                    }

                    applyingRecordService.update(applyingRecord);
                    log.info("update apply record status success");
                    incomeRecordService.insertList(incomeRecordList);
                    log.info("create income record success,uid is " + stringBuilder);
                    userAssetService.updateList(userAssetList);
                    log.info("update user asset success,uid is " + stringBuilder);
                }
                model.addAttribute("code", 0);
                return "/common/success";
            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("update applyingRecord error,id is  " + id);
                model.addAttribute("code", -1);
            }

            return "/data/json";
        }

    }
    //更新合伙人收入信息
    private void updateCopartnerInfo(ModelMap model, ApplyingRecord applyingRecord, List<IncomeRecord> incomeRecordList, List<UserAsset> userAssetList, StringBuilder stringBuilder, BigDecimal verifyAmount, Long agentId, User secondAgent, Long firstAgentId, boolean hasFirst, boolean hasSecond, Product product, BigDecimal agentAmount) {
        if (hasFirst) {
            //上级代理比例
            BigDecimal firstRebateRate = product.getFirstRate().divide(BigDecimal.valueOf(100), 10, BigDecimal.ROUND_HALF_UP);
            log.info("firstRebateRate=" + firstRebateRate);
            //上级代理金额 = 佣金*上级代理比例
            BigDecimal firstRebateAmount = verifyAmount.multiply(firstRebateRate);
            log.info("firstRebateAmount=rebateAmount*firstRebateRate---> " + firstRebateAmount);
            applyingRecord.setFirstProxyAmount(firstRebateAmount);
            //08.21废弃 代理收入=收入-上级、上上级代理收入
            //08.21修改 代理收入不变
//            agentAmount = agentAmount.subtract(firstRebateAmount);

            //创建上级代理人收入记录
            IncomeRecord firstIncomeRecord = new IncomeRecord();
            firstIncomeRecord.setProductId(applyingRecord.getProductId());
            firstIncomeRecord.setType(IncomeRecord.TYPE_COPARTNER);
            firstIncomeRecord.setLevel(IncomeRecord.LEVEL_FIRST);
            firstIncomeRecord.setAmount(firstRebateAmount);
            firstIncomeRecord.setTargetId(applyingRecord.getId());
            firstIncomeRecord.setUid(firstAgentId);
            firstIncomeRecord.setCreateBy(agentId);
            firstIncomeRecord.setUpdateBy(agentId);
            incomeRecordList.add(firstIncomeRecord);
            stringBuilder.append(firstAgentId).append(",");
            //上级资产更新
            UserAsset firstUserAsset = updateUserAsset(firstIncomeRecord, model);
            userAssetList.add(firstUserAsset);
            if (hasSecond) {
                //上上级代理比例
                BigDecimal secondRebateRate = product.getSecondRate().divide(BigDecimal.valueOf(100), 10, BigDecimal.ROUND_HALF_UP);
                log.info("secondRebateRate=" + secondRebateRate);
                //上上级代理金额 = 佣金*上级代理比例
                BigDecimal secondRebateAmount = verifyAmount.multiply(secondRebateRate);
                log.info("secondRebateAmount=rebateAmount*secondRebateRate---> " + secondRebateAmount);
                applyingRecord.setSecondProxyAmount(secondRebateAmount);
                //08.21废弃 代理收入=收入-上级、上上级代理收入
                //08.21修改 代理收入不变
//              agentAmount = agentAmount.subtract(secondRebateAmount);

                //创建上上级代理人收入记录
                IncomeRecord secondIncomeRecord = new IncomeRecord();
                secondIncomeRecord.setProductId(applyingRecord.getProductId());
                secondIncomeRecord.setType(IncomeRecord.TYPE_COPARTNER);
                secondIncomeRecord.setLevel(IncomeRecord.LEVEL_SECOND);
                secondIncomeRecord.setAmount(secondRebateAmount);
                secondIncomeRecord.setTargetId(applyingRecord.getId());
                secondIncomeRecord.setUid(secondAgent.getId());
                secondIncomeRecord.setCreateBy(agentId);
                secondIncomeRecord.setUpdateBy(agentId);
                incomeRecordList.add(secondIncomeRecord);
                stringBuilder.append(secondAgent.getId()).append(",");
                //上上级资产更新
                UserAsset secondUserAsset = updateUserAsset(secondIncomeRecord, model);
                userAssetList.add(secondUserAsset);

            }
        }
    }

    //资产情况更新
    private UserAsset updateUserAsset(IncomeRecord incomeRecord, ModelMap model) {
        try {
            BigDecimal currentAmount = incomeRecord.getAmount();
            UserAsset userAsset = userAssetService.getObjectById(incomeRecord.getUid());
            //更新今日收入
            userAsset.setTodayAmount(userAsset.getTodayAmount().add(currentAmount));
            //返佣收入
            if (IncomeRecord.TYPE_REBATE.equals(incomeRecord.getType())) {
                userAsset.setRebateAmount(userAsset.getRebateAmount().add(currentAmount));
            }
            //合伙人收入
            if (IncomeRecord.TYPE_COPARTNER.equals(incomeRecord.getType())) {
                //一级合伙人收入
                if (IncomeRecord.LEVEL_FIRST.equals(incomeRecord.getLevel())) {
                    userAsset.setFirstCoprtnerAmout(userAsset.getFirstCoprtnerAmout().add(currentAmount));
                }
                //二级合伙人收入
                if (IncomeRecord.LEVEL_SECOND.equals(incomeRecord.getLevel())) {
                    userAsset.setSecondCoprtnerAmout(userAsset.getSecondCoprtnerAmout().add(currentAmount));
                }
                //此处多了合伙人总收入
                userAsset.setCopartnerAmount(userAsset.getCopartnerAmount().add(currentAmount));
            }
            //余额
            userAsset.setSurplusAmount(userAsset.getSurplusAmount().add(currentAmount));
            userAsset.setUpdateBy(incomeRecord.getUpdateBy());
            return userAsset;
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("updateUserAsset error ");
            model.addAttribute("code", -1);
        }
        return null;
    }
}

