package com.ptteng.keeper.admin.utils;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.TimeUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.keeper.common.model.ApplyingRecord;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 解析盘库excel和倒查excel
 *
 * @author liut
 */
public class ParseExcel {


    private static final Log log = LogFactory.getLog("parseExcel");

    /**
     * 上传的临时文件在服务器上的存放路径
     */
    public static final String FILE_PATH = "/data/temp/keeper";

    /**
     * 2003和2007excel文件的尾缀
     */
    public static final String[] EXCEL_SUFFIX = {"xls", "xlsx", "csv"};

    static {
        PropertiesUtil.loadFiles("cfg/excel.properties");
    }

    private static final Map<String, String> KVMap = PropertiesUtil.propertesToMap(PropertiesUtil.loadFilesToProps("cfg/excel.properties"));
    /**
     * 用户excel表中有用的6个字段，按序排列
     * grade class name userType mobile mail pwd
     */
    static final int[] inventory_colums = {0, 1, 2, 3, 4, 5, 6};


    /**
     * 解析excel
     *
     * @param inventoryUrl
     * @return
     */
    public static Map<String, Object> excelToSqlMap(String inventoryUrl, Map<String, List<BigDecimal>> v) {
        List<Map<String, String>> list = new ArrayList<>();
        StringBuilder sql = new StringBuilder();
        Map<String, Object> sqlMap = new HashMap<>();
        log.info("argument inventoryUrl is: " + inventoryUrl);
        if (StringUtils.isEmpty(inventoryUrl)) {
            log.info("arg inventoryUrl is empty");
            return null;
        }
        //服务器用
//        Workbook wb = getWb(getExcelFilePath(inventoryUrl));
        //本地调试用
        Workbook wb = getWb(inventoryUrl);
        if (wb == null) {
            log.info("no workBook, can not parse");
            return null;
        }
        /* 固定只取出第一张sheet */
        Sheet sheet_0 = wb.getSheetAt(0);
        if (sheet_0 == null) {
            log.info("no first sheet, can not parse");
            return null;
        }
        //处理字段index值(key为列index，value为值）
        Map<Integer, String> map = new HashMap<>();

        try {
            int rowNums = 1;
            // 共有多少列，配置文件中配置字段的数量
            int colNum = KVMap.size();
            //清除掉excel中的空行
            CellReference cellReference = new CellReference("A4");
            boolean flag = false;
            log.info("当前总行数：" + (sheet_0.getLastRowNum() + 1));
            for (int i = cellReference.getRow(); i <= sheet_0.getLastRowNum(); ) {
                Row r = sheet_0.getRow(i);
                if (r == null) {
//                    log.info("如果是空行（即没有任何数据、格式），直接把它以下的数据往上移动");
                    // 如果是空行（即没有任何数据、格式），直接把它以下的数据往上移动
                    sheet_0.shiftRows(i + 1, sheet_0.getLastRowNum(), -1);
                    continue;
                }
                flag = false;
                for (Cell c : r) {
                    if (c.getCellType() != Cell.CELL_TYPE_BLANK) {
                        flag = true;
                        break;
                    }
                }
                if (flag) {
                    i++;
                    continue;
                } else {
                    //如果是空白行（即可能没有数据，但是有一定格式）
                    if (i == sheet_0.getLastRowNum()) {
                        //如果到了最后一行，直接将那一行remove掉
                        sheet_0.removeRow(r);
                    } else {
                        //如果还没到最后一行，则数据往上移一行
                        sheet_0.shiftRows(i + 1, sheet_0.getLastRowNum(), -1);
                    }
                }
            }
            rowNums = sheet_0.getLastRowNum() + 1;
            log.info("整理后总行数" + rowNums);
            for (int i = 0; i < rowNums; i++) {
                log.info("============ i ============ " + i);
                Row row = sheet_0.getRow(i);
//                log.info("total rowNum: " + rowNums + ", total colNum: " + colNum);
                //取表头
                if (i == 0) {
                    for (int j = 0; j < colNum; j++) {
                        Cell cell = row.getCell(j);
                        String value = getValue(cell);

                        if (DataUtils.isNullOrEmpty(value)) {
                            log.info("value is null");
                            continue;
                            //以表头值为key，表字段值为value，如果找到user表对应的值，则进行转换
                        } else {
                        }
                        map.put(j, value);
                    }
                } else {
                    String value = null;


                    Map<String, String> m = new HashMap<>();
                    for (int j = 0; j < colNum; j++) {
                        Cell cell = row.getCell(j);
                        value = getValue(cell);
                        if (DataUtils.isNullOrEmpty(value)) {
                            log.info(KVMap.get(map.get(j)) + "value is null");
                            log.info("value is null");
                            continue;
                        }
                        //格式：product_id:2
                        m.put(KVMap.get(map.get(j)), value);
                    }
                    log.info("m=" + m);
                    if (!m.isEmpty()){
                        list.add(m);
                    }
                }
            }
            sqlMap.put("@table", "applying_record");
            sqlMap.put("@query", "id");

            log.info("list is ===" + list);
            for (int x = 0, len = list.size(); x < len; x++) {
                Map<String, String> item = list.get(x);
                if (x != 0) {
                    sql.append(" union ");
                }
                String mobile = item.get("mobile");
                mobile=replaceBlank(mobile);
                log.info("mobile="+mobile+".");
                log.info(item.get("verify_amount"));
                //key=手机号前三位+后四位+产品id
                //先检查有没有此key，有就push，没有就新增
                String key = getKey(mobile, item.get("product_id"));
                BigDecimal value = new BigDecimal(item.get("verify_amount"));
                List<BigDecimal> bigDecimalList;
                if (v.containsKey(key)) {
                    bigDecimalList = v.get(key);
                } else {
                    bigDecimalList = new ArrayList<>();
                }
                bigDecimalList.add(value);
                v.put(key,bigDecimalList );
                sql.append("SELECT id FROM applying_record where  left(mobile,3) = left(").append("'").append(mobile).append("'").append(", 3) and right(mobile,4) = right(").append("'").append(mobile).append("'").append(", 4)").append(" and product_id=").append(item.get("product_id"));
            }
            sqlMap.put("id", "-1 union " + sql.toString());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            return null;
        }
        log.info("sql ="+SQLUtil.convert2Sql(sqlMap,0,Integer.MAX_VALUE));
        return sqlMap;
    }

    public static String getKey(String mobile, String productId) {
        String key = mobile.substring(0, 3) + mobile.substring(7, 11) + productId;
        log.info("key =" + key);
        String[] a = key.split("\\.");
        log.info(a.length);
        return a[0];
    }
    /*
     * 去除数据的空格、回车、换行符、制表符
     */
    public static String replaceBlank(String str) {
        String dest = "";
        if (str!=null) {
            //空格\t、回车\n、换行符\r、制表符\t
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }


    /**
     * 每个cell中的值
     *
     * @param cell
     * @return
     */
    private static String getValue(Cell cell) {

//        log.info("取值为 " + cell);
        if (DataUtils.isNullOrEmpty(cell)) {
            return "";
        }
        if (cell.getCellType() == Cell.CELL_TYPE_BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted(cell)) {
                Date d = cell.getDateCellValue();
                return DateFormatUtils.format(d, "yyyy/MM/dd");
            } else {
                //不强制转整数了
                return String.valueOf(cell.getNumericCellValue());
            }
        } else {
            return String.valueOf(cell.getStringCellValue());
        }

    }

    /**
     * 拿到workbook对象
     *
     * @param excelFilePath
     * @return
     */
    private static Workbook getWb(String excelFilePath) {
        String suffix = excelFilePath.substring(excelFilePath.lastIndexOf(".") + 1);
        log.info("suffix is: " + suffix);
        InputStream is;
        Workbook wb = null;
        try {
            log.info("excelFilePath=" + excelFilePath);

            excelFilePath = URLDecoder.decode(excelFilePath, "utf-8");
            log.info("decode excelFilePath=" + excelFilePath);
            is = new FileInputStream(excelFilePath);
            if (EXCEL_SUFFIX[0].equals(suffix)) {
                log.info("file is xls");
                wb = new HSSFWorkbook(is);
            } else if (EXCEL_SUFFIX[1].equals(suffix)) {
                log.info("file is xlsx");
                wb = new XSSFWorkbook(is);
            } else {
                log.info("file is other, illegal");
                wb = null;
            }
        } catch (FileNotFoundException ex) {
            log.error("getWb error...", ex);
            wb = null;
        } catch (IOException ex) {
            log.error("getWb error...", ex);
            wb = null;
        }
        return wb;
    }

    /**
     * 根据url拼接excel文件在服务器上的临时存放路径
     *
     * @param url
     * @return
     */
    public static String getExcelFilePath(String url) {
        log.info("argument url is: " + url);
        int begin = url.lastIndexOf("/") - 1;
        String temp = url.substring(begin, url.length());
        log.info("temp is:" + temp);
        return FILE_PATH + "/" + temp;
    }

    public static void main(String[] args) {
    }
}
