package com.ptteng.keeper.admin.utils;


import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    private static Properties props = new Properties();

//    public PropertiesUtil() {
//    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static String getPropertyByProps(Properties props1, String key) {
        return props1.getProperty(key);
    }

    public static Map<String, Object> getPropertesMap() {
        return new HashMap<String, Object>((Map) props);
    }

    public static Map<String, String> propertesToMap(Properties p) {
        return new HashMap<String, String>((Map) p);
    }

    public static void loadFiles(String path) {
        InputStream fis = PropertiesUtil.class.getClassLoader().getResourceAsStream(path);

        try {
            props.load(fis);
        } catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public static Properties loadFilesToProps(String path) {
        Resource resource = new ClassPathResource(path);
        Properties props1 = new Properties();
        try {
            InputStream is = resource.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            props1.load(bf);
        } catch (IOException var2) {
            var2.printStackTrace();
        }
        return props1;
    }
//    static {
//
//
//    }
}