package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * WithdrawRecord  crud
 *
 * @author lishoabo
 * @Date 2018-08-01 13:43
 */
@Controller
public class WithdrawRecordController {
    private static final Log log = LogFactory.getLog(WithdrawRecordController.class);

    @Autowired
    private WithdrawRecordService withdrawRecordService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ApplyingRecordService applyingRecordService;
    @Autowired
    private ManagerService managerService;


    /**
     * show 提现列表
     *
     * @param mobile        手机号
     * @param status        提现状态
     * @param createAtStart 申请时间开始
     * @param createAtEnd   申请时间结束
     * @param updateAtStart 处理时间开始
     * @param updateAtEnd   处理时间结束
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/search", method = RequestMethod.GET)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, Integer page,
                                                                            Integer size, String mobile, Integer status, Long createAtStart, Long createAtEnd, Long updateAtStart, Long updateAtEnd) throws Exception {
        log.info("withdraw record search:" + LogUtil.convertParam("mobile", mobile, "status", status, "createAtStart", createAtStart, "createAtEnd", createAtEnd,
                "updateAtStart", updateAtStart, "updateAtEnd", updateAtEnd));

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> map = DynamicUtil.getWithdrawRecordList(mobile, status, createAtStart, createAtEnd, updateAtStart, updateAtEnd, false);
            Map<String, Object> totalMap = DynamicUtil.getWithdrawRecordList(mobile, status, createAtStart, createAtEnd, updateAtStart, updateAtEnd, true);
            List<Long> ids = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, start, size);
            List<WithdrawRecord> withdrawRecordList = withdrawRecordService.getObjectsByIds(ids);

            BigInteger total = (BigInteger) withdrawRecordService.getObjectByDynamicCondition(WithdrawRecord.class, totalMap, 0, Integer.MAX_VALUE);

            List<Long> uids = MyListUtil.getList(WithdrawRecord.class.getDeclaredField("uid"), withdrawRecordList);
            List<User> userList = userService.getObjectsByIds(uids);

            List<Long> mids = MyListUtil.getList(WithdrawRecord.class.getDeclaredField("updateBy"), withdrawRecordList);
            List<Manager> managerList= managerService.getObjectsByIds(mids);
            log.info("pids size= " + mids.size());

            log.info("get withdraw record size is " + total);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("withdrawRecordList", withdrawRecordList);
            model.addAttribute("userList", userList);
            model.addAttribute("managerList", managerList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/withdrawRecord/json/withdrawRecordListJson";
    }

    /**
     * show 提现详情
     *
     * @param id 提现单号
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/{id}", method = RequestMethod.GET)
    public String getWithdrawDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("withdraw record detail:id=" + id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1100);
            return "/common/success";
        }
        try {
            //获取提现记录
            WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
            //此次发起记录时间
            Long start = 0L;
            Long end = withdrawRecord.getCreateAt();
            log.info("本次提现时间 "+ MyTimeUtil.convertLong2String(withdrawRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));
            //获取上次提现记录
            WithdrawRecord lastRecord;
            Map<String,Object> map = DynamicUtil.getPreWithdarwRecord(withdrawRecord.getUid(), "1,2", null, withdrawRecord.getCreateAt(), false);
            List<Long> lastRecordIds = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, 0, Integer.MAX_VALUE);
            if (lastRecordIds.size() > 0) {
                Long lastId = lastRecordIds.get(0);
                    lastRecord = withdrawRecordService.getObjectById(lastId);
                    start = lastRecord.getCreateAt();
                log.info("上次提现时间（非拒绝）"+ MyTimeUtil.convertLong2String(lastRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));

            }
            log.info("收入时间区间"+ MyTimeUtil.convertLong2String(start,"YY-MM-dd HH:mm:ss")+" - "+MyTimeUtil.convertLong2String(end,"YY-MM-dd HH:mm:ss"));
            //获取上次提现、到此次提现的收入记录
            Map<String, Object> map2 = DynamicUtil.getIncomRecordList(start, end, withdrawRecord.getUid(), null, false);
            List<Long> ids = incomeRecordService.getIdsByDynamicCondition(IncomeRecord.class, map2, 0, Integer.MAX_VALUE);
            List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(ids);
            for (IncomeRecord incomeRecord : incomeRecordList) {
                log.info("收入时间"+ MyTimeUtil.convertLong2String(incomeRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));

            }
            List<Long> pids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("productId"), incomeRecordList);
            List<Product> productList = productService.getObjectsByIds(pids);
            //申请单
            List<Long> aids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("targetId"), incomeRecordList);
            List<ApplyingRecord> applyingRecordList = applyingRecordService.getObjectsByIds(aids);
            model.addAttribute("code", 0);

            model.addAttribute("incomeRecordList", incomeRecordList);
            model.addAttribute("productList", productList);
            model.addAttribute("applyingRecordList", applyingRecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord detail error ");
            // for test
            model.addAttribute("code", -1);
        }

        return "/keeper/incomeRecord/json/incomeRecordListJson";
    }

    /**
     * show 提现核验
     *
     * @param ids        通过记录id
     * @param withdrawId 提现申请单id
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/withdraw/{withdrawId}/verify", method = RequestMethod.PUT)
    public String getWithdrawDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody List<Long> ids, @PathVariable Long withdrawId) throws Exception {
        log.info("withdraw record verify:ids=" + ids + " ,withdrawId=" + withdrawId);

        if (DataUtils.isNullOrEmpty(withdrawId)) {
            model.addAttribute("code", -1100);
            return "/common/success";
        }
        try {
//获取提现记录
            WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(withdrawId);
            //校验提现单状态，非申请中的不再处理
            if (!WithdrawRecord.STATUS_APPLYING.equals(withdrawRecord.getStatus())) {
                model.addAttribute("code", -5030);
                return "common/success";
            }

            //此次发起记录时间
            Long start = 0L;
            Long end = withdrawRecord.getCreateAt();
            log.info("本次提现时间 "+ MyTimeUtil.convertLong2String(withdrawRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));
            //获取上次提现记录
            WithdrawRecord lastRecord;
            Map<String,Object> map = DynamicUtil.getPreWithdarwRecord(withdrawRecord.getUid(), "1,2", null, withdrawRecord.getCreateAt(), false);
            List<Long> lastRecordIds = withdrawRecordService.getIdsByDynamicCondition(WithdrawRecord.class, map, 0, Integer.MAX_VALUE);
            if (lastRecordIds.size() > 0) {
                Long lastId = lastRecordIds.get(0);
                lastRecord = withdrawRecordService.getObjectById(lastId);
                start = lastRecord.getCreateAt();
                log.info("上次提现时间（非拒绝）"+ MyTimeUtil.convertLong2String(lastRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));

            }
            log.info("收入时间区间"+ MyTimeUtil.convertLong2String(start,"YY-MM-dd HH:mm:ss")+" - "+MyTimeUtil.convertLong2String(end,"YY-MM-dd HH:mm:ss"));
            //获取上次提现、到此次提现的收入记录
            Map<String, Object> map2 = DynamicUtil.getIncomRecordList(start, end, withdrawRecord.getUid(), null, false);
            List<Long> allIds = incomeRecordService.getIdsByDynamicCondition(IncomeRecord.class, map2, 0, Integer.MAX_VALUE);
            List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(allIds);
            for (IncomeRecord incomeRecord : incomeRecordList) {
                log.info("收入时间"+ MyTimeUtil.convertLong2String(incomeRecord.getCreateAt(),"YY-MM-dd HH:mm:ss"));

            }
            Map<Long, IncomeRecord> incomeRecordMap = MyListUtil.convert2Map(IncomeRecord.class.getDeclaredField("id"), incomeRecordList);


            //先全部设置为拒绝
            List<IncomeRecord> allList = new ArrayList<>();
            for (Long id : allIds) {
                IncomeRecord incomeRecord = incomeRecordMap.get(id);
                incomeRecord.setStatus(IncomeRecord.STATUS_DISABLED);
                allList.add(incomeRecord);
            }
            //通过收入列表
            List<IncomeRecord> updateList = new ArrayList<>();

            List<IncomeRecord> agreeIncomeRecordList = incomeRecordService.getObjectsByIds(ids);
            //计算通过的总收入
            BigDecimal agreeAmount = BigDecimal.ZERO;
            for (IncomeRecord incomeRecord : agreeIncomeRecordList) {
                agreeAmount = agreeAmount.add(incomeRecord.getAmount());
                incomeRecord.setStatus(IncomeRecord.STATUS_ENABLED);
                updateList.add(incomeRecord);
                log.info(updateList);
            }
            //去重+添加
            boolean b=allList.removeAll(updateList);
            log.info("remove "+ b);
            allList.addAll(updateList);

            incomeRecordService.updateList(allList);
            log.info("user income record update success");
            //处理用户提现金额
            log.info("user withdraw amount from " + withdrawRecord.getAmount() + " to " + agreeAmount);
            withdrawRecord.setAmount(agreeAmount);
            withdrawRecordService.update(withdrawRecord);
            //处理用户资产
            UserAsset userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
            userAsset.setApplyingAmount(agreeAmount);
            userAssetService.update(userAsset);
            log.info("user applyingAmount update success");
            log.info("user withdrawRecord update success");
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord detail error ");
            // for test
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }
@Test
public void se() {
    List<Long> a = new ArrayList<>();
    a.add(7L);
    List<Long> b = new ArrayList<>();
    b.add(7L);
    a.removeAll(b);
    log.info(a);
}

    /**
     * show 提现审批
     *
     * @param id     申请id
     * @param status 状态 2通过 3拒绝
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/withdraw/{id}/status", method = RequestMethod.PUT)
    public String updateWithdrawRecordJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {

        log.info("update withdrawRecord  status: id= " + id + " ,status=" + status);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1100);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(status)) {
            model.addAttribute("code", -2002);
            return "/common/success";
        } else if (status > WithdrawRecord.STATUS_REJECT) {
            model.addAttribute("code", -2002);
            return "/common/success";
        }
        Manager manager = (Manager) request.getAttribute("manager");
        try {
            WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(withdrawRecord)) {
                model.addAttribute("code", -1005);
                return "/common/success";
            }
            withdrawRecord.setStatus(status);
            withdrawRecord.setUpdateBy(manager.getId());
            withdrawRecordService.update(withdrawRecord);
            log.info("update withdraw record success");
            UserAsset userAsset = userAssetService.getObjectById(withdrawRecord.getUid());
            //设置重置用户资产
            log.info("user applyingAmount=" + userAsset.getApplyingAmount());
            //通过or拒绝：申请中金额=申请中金额-提现金额
            userAsset.setApplyingAmount(userAsset.getApplyingAmount().subtract(withdrawRecord.getAmount()));
            log.info("user applyingAmount=" + userAsset.getApplyingAmount());

            if (status.equals(WithdrawRecord.STATUS_REJECT)) {
                log.info("user surplusAmount=" + userAsset.getSurplusAmount());
                //拒绝： 余额=余额+申请中金额
                userAsset.setSurplusAmount(userAsset.getSurplusAmount().add(userAsset.getApplyingAmount()));
                log.info("user surplusAmount=" + userAsset.getSurplusAmount());
            }
            userAssetService.update(userAsset);
            log.info("update user asset success");
            model.addAttribute("code", 0);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update withdrawRecord error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

}

