package com.ptteng.keeper.admin.utils;

import com.ptteng.keeper.common.model.User;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Component
public class AcademyUserUtil {

    @Autowired
    private CookieUtil cookieUtil;

    public static AcademyUserUtil academyUserUtil;

    @PostConstruct
    public void init() {
        academyUserUtil = this;
    }

    public static Long getUserIdLongValue(HttpServletRequest request) {

        Long userIdLong = 0L;

        String userIdStr = academyUserUtil.cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        if (DataUtils.isNotNullOrEmpty(userIdStr)) {

            return Long.valueOf(userIdStr);

        } else if (DataUtils.isNullOrEmpty(userIdStr)) {

            User user = (User) request.getAttribute("user");

            return user.getId();
        }

        return userIdLong;
    }
}
