package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.admin.utils.ObjectConvertUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.CopartnerRelation;
import com.ptteng.keeper.common.model.IncomeRecord;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.model.UserAsset;
import com.ptteng.keeper.common.service.CopartnerRelationService;
import com.ptteng.keeper.common.service.IncomeRecordService;
import com.ptteng.keeper.common.service.UserAssetService;
import com.ptteng.keeper.common.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * @author cjsff
 * @Description :用户
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private CopartnerRelationService copartnerRelationService;
    @Autowired
    private IncomeRecordService incomeRecordService;


    /**
     * show 用户列表
     *
     * @param id              用户id
     * @param nick            用户昵称
     * @param mobile          用户手机
     * @param invitationCode  邀请码
     * @param recommendMobile 邀请人手机号
     * @param status          状态
     * @param startTime       注册时间开始
     * @param endTime         注册时间结束
     * @return 列表
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
    public String getUserIdsByOpenIDJsonList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, Long id, String nick, String mobile, Long startTime, Long endTime, String invitationCode, String recommendMobile, Integer status) throws Exception {

        log.info("--------------------------search user start-----------------------------------");

        log.info("user search list:" + LogUtil.convertParam("id", id, "nick", nick, "mobile", mobile, "startTime", startTime, "endTime", endTime, "invitationCode",
                invitationCode, "recommendMolibe", recommendMobile, "status", status));
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }

        int start = (page - 1) * size;

        if (start < 0) {
            start = 0;
        }

        Long total = 0L;

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<User> userList = new ArrayList<>();
            List<User> firstRecommend = new ArrayList<>();
            List<UserAsset> userAssetList = new ArrayList<>();
            Map<String, Object> userParams = DynamicUtil.getUserList(id, nick, mobile, invitationCode, recommendMobile, status, startTime, endTime, false);
            List<Long> userIds = userService.getIdsByDynamicCondition(User.class, userParams, start, size);
            //获取用户
            if (userIds.size() > 0) {
                userList = userService.getObjectsByIds(userIds);
                //获取推荐人信息
                List<Long> recommendIds = MyListUtil.getList(User.class.getDeclaredField("recommendId"), userList);
                if (recommendIds.size() > 0) {
                    firstRecommend = userService.getObjectsByIds(recommendIds);
                }
                //获取用户资产信息
                userAssetList = userAssetService.getObjectsByIds(userIds);
            }


            Map<String, Object> totalParams = DynamicUtil.getUserList(id, nick, mobile, invitationCode, recommendMobile, status, startTime, endTime, true);
            total = userService.getIdsByDynamicCondition(User.class, totalParams, 0, Integer.MAX_VALUE).get(0);

            log.info("--------------------------search user end-----------------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

            model.addAttribute("userList", userList);
            model.addAttribute("userAssetList", userAssetList);
            model.addAttribute("firstRecommend", firstRecommend);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/userListJson";
    }


    /**
     * show 用户详情
     *
     * @param id 用户id
     * @return 用户信息 用户资产信息
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUserIdsByOpenIDList1(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("-----------------------user details start-----------------------");

        log.info("id is :" + id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        try {
            //用户信息
            User user = userService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(user)) {
                model.addAttribute("code", -1005);
                return "/common/success";
            }
            //用户资产
            UserAsset userAsset = userAssetService.getObjectById(id);
            //上级信息
            User firstRecommend = new User();
            User secondRecommend = new User();
            if (!Constants.DEFAULT_LONG_NONE.equals(user.getRecommendId())) {
                firstRecommend = userService.getObjectById(user.getRecommendId());
                if (!Constants.DEFAULT_LONG_NONE.equals(firstRecommend.getRecommendId())) {
                    secondRecommend = userService.getObjectById(firstRecommend.getRecommendId());
                }
            }
            //下级/下下级合伙人列表
            List<Long> copartnerrelationIds = copartnerRelationService.getCopartnerRelationIdsByUidOrderByCreateAt(user.getId(), 0, Integer.MAX_VALUE);
            List<CopartnerRelation> copartnerRelationList = new ArrayList<>();
            if (copartnerrelationIds.size() > 0) {
                copartnerRelationList = copartnerRelationService.getObjectsByIds(copartnerrelationIds);
            }
            Map<Integer, List<CopartnerRelation>> copartnerMap = MyListUtil.convert2ListMap(CopartnerRelation.class.getDeclaredField("level"), copartnerRelationList);
            //下级合伙人id
            log.info("copartnerMap is" + copartnerMap);
            List<CopartnerRelation> fcr = copartnerMap.get(CopartnerRelation.LEVEL_FIRST);

            List<Long> fuids = MyListUtil.getList(CopartnerRelation.class.getDeclaredField("subUid"), fcr);
            List<User> firstCopartnerList = userService.getObjectsByIds(fuids);
            log.info("firstCopartnerList size is " + firstCopartnerList.size());
            //下级合伙人收入
            Map<String, Object> fmap = DynamicUtil.getSumAmountByUidAndLevel(id, IncomeRecord.LEVEL_FIRST);
            Object fresult = incomeRecordService.getObjectByDynamicCondition(IncomeRecord.class, fmap, 0, Integer.MAX_VALUE);

            List<Object[]> fAmount = (List<Object[]>) ObjectConvertUtil.objectToArrayList(fresult);
            log.info("fAmount size is " + fAmount.size());
            //下下级合伙人id
            List<CopartnerRelation> scr = copartnerMap.get(CopartnerRelation.LEVEL_SECOND);
            List<Long> suids = MyListUtil.getList(CopartnerRelation.class.getDeclaredField("subUid"), scr);
            List<User> secondCopartnerList = userService.getObjectsByIds(suids);
            log.info("secondCopartnerList size is " + secondCopartnerList.size());

            //下下级合伙人收入
            Map<String, Object> smap = DynamicUtil.getSumAmountByUidAndLevel(id, IncomeRecord.LEVEL_SECOND);
            Object sresult = incomeRecordService.getObjectByDynamicCondition(IncomeRecord.class, smap, 0, Integer.MAX_VALUE);
            ;
            List<Object[]> sAmount = (List<Object[]>) ObjectConvertUtil.objectToArrayList(sresult);
            log.info("sAmount size is " + sAmount.size());
            model.addAttribute("user", user);
            model.addAttribute("userAsset", userAsset);
            model.addAttribute("firstRecommend", firstRecommend);
            model.addAttribute("secondRecommend", secondRecommend);

            model.addAttribute("secondCopartnerList", secondCopartnerList);
            model.addAttribute("firstCopartnerList", firstCopartnerList);
            model.addAttribute("fAmount", fAmount);
            model.addAttribute("sAmount", sAmount);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/keeper/user/json/userDetailJson";
    }


    /**
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     * @Description:修改用户账号状态
     */
    @RequestMapping(value = "/a/u/user/{id}/status", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {

        log.info("-------------------update user status start-----------------------");

        log.info("id is :" + id + ",status is :" + status);
        Manager manager = (Manager) request.getAttribute("manager");
        if (DataUtils.isNullOrEmpty(status)) {
            log.info("status is null");
            model.addAttribute("code", -5055);
            return "/common/success";
        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -1000);

                return "/common/success";
            }
            if (!user.getStatus().equals(status)){
                user.setStatus(status);
                user.setUpdateBy(manager.getId());
                userService.update(user);
            }
            log.info("-------------------update user status end-----------------------");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }


    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id, String mobile, Integer status) throws Exception {

        log.info("------------------------update user start------------------------");

        log.info("id is :" + id + ",mobile is :" + mobile + ",status is :" + status);
        Manager manager = (Manager) request.getAttribute("manager");
        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -1000);

                return "/common/success";
            }
            if (DataUtils.isNotNullOrEmpty(mobile)) {
                user.setMobile(mobile);
                user.setUpdateBy(manager.getId());
                log.info("user id=" + id + " mobile is change to " + mobile + " , manager=" + manager.getId());
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                user.setStatus(status);
            }
            userService.update(user);
            log.info("------------------------update user end------------------------");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

}

