package com.ptteng.fans.common.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "brand")
public class Brand implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 5879125444824052736L;
  public static final int IS_DEFAULT=1;
  public static final int IS_NO_DEFAULT=0;

  private Long id;

  private Long uid;

  private String name;

  private String slogan;

  private String mobile;


  private String wechat;


  private String url;


  private String logo;


  private String introduction;


  private Long createAt;


  private Long createBy;


  private Long updateAt;


  private Long updateBy;

  //冻结状态 1:正常 2:冻结
  private Integer status;

  //背景图片
  private String cover;

  //是否默认
  private Integer isDefault;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "uid")
  public Long getUid(){
    return uid;
  }

  public void setUid(Long uid) {
    this.uid = uid;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  @Column(name = "slogan")
  public String getSlogan() {
    return slogan;
  }


  public void setSlogan(String slogan) {
    this.slogan = slogan;
  }

  @Column(name = "mobile")
  public String getMobile() {
    return mobile;
  }


  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  @Column(name = "wechat")
  public String getWechat() {
    return wechat;
  }


  public void setWechat(String wechat) {
    this.wechat = wechat;
  }

  @Column(name = "url")
  public String getUrl() {
    return url;
  }


  public void setUrl(String url) {
    this.url = url;
  }

  @Column(name = "logo")
  public String getLogo() {
    return logo;
  }


  public void setLogo(String logo) {
    this.logo = logo;
  }

  @Column(name = "introduction")
  public String getIntroduction() {
    return introduction;
  }


  public void setIntroduction(String introduction) {
    this.introduction = introduction;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }
    @Column(name = "cover")
    public String getCover() {
        return cover;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    @Column(name = "is_default")
    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

