package com.ptteng.fans.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "base_classify_jp")
public class BaseClassifyJp implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4311232227619198592L;

	/**
	 * 10=可以创建子级
	 */
	public static final Integer IS_CREATE = 10;

	/**
	 *  20=不可以创建子级
	 */
	public static final Integer IS_NOT_CREATE = 20;

	/**
	 *  上架状态
	 * 
	 */
	public static final Integer STATUS_ON = 1;
    	
	/**
	 *  下架状态
	 * 
	 */
	public static final Integer STATUS_OFF = 0;
	/**
	 *  普通分类
	 *
	 */
	public static final int TYPE_NARMAL = 1;
	/**
	 *  电商分类
	 *
	 */
	public static final int TYPE_MALL = 2;
	/**
	 *  名片部门
	 *
	 */
	public static final int TYPE_DEPARTMENT = 3;

   /**
   *  主键,自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  分级
   *
   */
    private  Integer level;
	
  
   /**
   *  介绍
   *
   */
    private  String intro;
	
  
   /**
   *  背景图
   *
   */
    private  String coverUrl;

    /**
     *  icon
     *
     */
    private  String icon;
   /**
   *  名称
   *
   */
    private  String name;
	
  
   /**
   *  排序
   *
   */
    private  Long sort;
	
  
   /**
   *  二级分类id
   *
   */
    private  Long pid;

	/**
	 * 10=可以创建子级
	 *
	 * 20=不可以创建子级
	 * 是否可以创建子级
	 */
	private Integer isCreate=10;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  修改人
   *
   */
    private  Long updateBy;
	
  
   /**
   *  数据更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  数据创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  上下架
   *
   */
    private  Integer status;
	
  
   /**
   *  商户ID
   *
   */
    private  Long merchantId;
	
  
   /**
   *  应用类型
   *
   */
    private  Integer type;

	/**
	 * 0：普通内容  10：行业模板添加内容
	 */
	private Integer industryType;

	/**
	 * 组件ids json
	 */
	private String componentsIds;


	/**
	 * 模板IDS json
	 */
	private String templateIds;
	/**
	 * 分裂path
	 */
	private String path;

    private String pathDesc;
    private String langInfo;
         	 	   @Id
              	@Column(name = "id")
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "level")
	public Integer getLevel() {
		return level;
	}


	public void setLevel(Integer level) {
		this.level = level;
	}
		 	@Column(name = "intro")
	public String getIntro() {
		return intro;
	}


	public void setIntro(String intro) {
		this.intro = intro;
	}
		 	@Column(name = "cover_url")
	public String getCoverUrl() {
		return coverUrl;
	}


	public void setCoverUrl(String coverUrl) {
		this.coverUrl = coverUrl;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "sort")
	public Long getSort() {
		return sort;
	}


	public void setSort(Long sort) {
		this.sort = sort;
	}
		 	@Column(name = "pid")
	public Long getPid() {
		return pid;
	}


	@Transient
	public Integer getIsCreate() {
		return isCreate;
	}

	public void setIsCreate(Integer isCreate) {
		this.isCreate = isCreate;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}


	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}


	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "merchant_id")
	public Long getMerchantId() {
		return merchantId;
	}


	public void setMerchantId(Long merchantId) {
		this.merchantId = merchantId;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}


	public void setType(Integer type) {
		this.type = type;
	}

	@Column(name = "industry_type")
	public Integer getIndustryType() {
		return industryType;
	}

	public void setIndustryType(Integer industryType) {
		this.industryType = industryType;
	}

	@Column(name = "components_ids")
	public String getComponentsIds() {
		return componentsIds;
	}

	public void setComponentsIds(String componentsIds) {
		this.componentsIds = componentsIds;
	}

	@Transient
	public String getTemplateIds() {
		return templateIds;
	}

	public void setTemplateIds(String templateIds) {
		this.templateIds = templateIds;
	}
    @Column(name = "path")
    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }
    @Transient
    public String getPathDesc() {
        return pathDesc;
    }

    public void setPathDesc(String pathDesc) {
        this.pathDesc = pathDesc;
    }
    @Column(name = "lang_info")
    public String getLangInfo() {
        return langInfo;
    }

    public void setLangInfo(String lang) {
        this.langInfo = lang;
    }
    @Column(name = "icon")
    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
    public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

