package com.ptteng.fans.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "orders")
public class Orders implements Serializable {

    /**
     * 订单超时时间-统一为30分钟
     */
    public static final Long EXPIRATION_TIME = 1800000L;
    /**
     * 自动收货时间为7天
     */
    public static final Long RECEIVE_TIME = 604800000L;


    /**
     * 非续费订单
     */
    public static final Integer RENEWAL_ORDER_TYPE = -1;

    /**
     * 订单列表-查询全部订单
     */
    public static final Integer ALL_ORDERS = 0;
    /**
     * 支付失败
     */
    public static final int PAYMENT_FAIL = 0;

    /**
     * 已完成
     */
    public static final int STATUS_OVER = 1;
    /**
     * 待付款
     */
    public static final int STATUS_PENDING_PAYMENT = 2;
    /**
     * 已取消
     */
    public static final int STATUS_CANCEL = 3;
    /*
    * 已拒绝
    * */
    public static final int STATUS_REJECTED = 31;
    /**
     * 已退款
     */
    public static final int STATUS_REFUNDED = 4;
    /**
     * 已失效
     */
    public static final int STATUS_FAILURE = 5;

    /**
     * 已支付（待发货）
     */
    public static final int STATUS_PREPAID = 6;
    /*
    * 有接单(人数.未满)
    * */
    public static final int STATUS_PICKED = 61;
    /**
     * 待确认（已发货）
     */
    public static final int STATUS_WAITING_FINISH = 7;
    /**
     * 微信支付
     */
    public static final int WAY_WX = 1;
    /**
     * 支付宝支付
     */
    public static final int WAY_ALI = 2;
    /**
     * 支付宝支付
     */
    public static final int WAY_WX_APP = 3;
    /**
     * 苹果支付
     */
    public static final int WAY_APPLE = 4;
    /**
     * 支付
     */
    public static final Integer ORDER_TYPE_PAY = 1;
    /**
     * 续费
     */
    public static final Integer ORDER_TYPE_RENEWAL = 2;
    /**
     * 方案支付
     */
    public static final Integer TYPE_DEFAULT = 0;
    /**
     * 微官网定制支付
     */
    public static final Integer TYPE_MICRO_WEBSITE = 10;
    /**
     * 商户商品支付
     */
    public static final Integer TYPE_MERCHANT = 20;
    /**
     * 服务订单支付
     */
    public static final Integer TYPE_SERVICE = 30;
    /*
    * 闪工端保证金
    * */
    public static final Integer TYPE_DEPOSIT = 40;
    public static final int ORDERS_WAY_DIRECTLy = 2;
    public static final int ORDERS_WAY_CART = 1;

    /**
     *
     */
    private static final long serialVersionUID = 8086825195958205440L;
    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 用户id
     */
    private Long uid;

    /**
     * 用户手机号
     */
    private String phoneNumber;

    /**
     * 用户姓名
     */
    private String userName;


    /**
     * 第三方流水号
     */
    private String payNo;


    /**
     * 交易流水号
     */
    private String ordersNo;


    /**
     * 商品名称
     */
    private String product;


    /**
     * 订单金额
     */
    private BigDecimal amount;

    /**
     * 实际支付金额
     */
    private BigDecimal payAmount;

    /**
     * 交易类型(0:方案支付,10=微官网定制支付)
     */
    private Integer type;


    /**
     * 交易状态(1：已完成；2：待付款 3: 已取消 4:已退款 5:已失效 6:待接单 7：已接单)
     */
    private Integer status;


    /**
     * 第三方平台种类 1 微信 2 支付宝
     */
    private Integer way;


    /**
     * 支付时间
     */
    private Long payAt;


    /**
     * 订单生成时间
     */
    private Long orderAt;


    /**
     * 生成订单失效时间
     */
    private Long endAt;


    /**
     * 商品id
     */
    private Long goodsId;


    /**
     * 订单类型 1=支付 2=续费
     */
    private Integer orderType;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 订单支付超时时间
     */
    private Long timeOutAt;

    /**
     * 创建时间
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateBy;


    /**
     * 创建人
     */
    private Long updateAt;


    /**
     * 更新人
     */
    private Long createAt;
    /**
     * 发货时间
     */
    private Long deliveryAt;
    /**
     * 收货时间
     */
    private Long receiveAt;
    /**
     * 系统收货时间
     */
    private Long sysReceiveAt;
    /**
     * 运费
     */
    private String expressAmount;
    /**
     * 订单来源
     */
    private Integer ordersWay;
    /**
     * 支付自增码
     */
    private Integer payRand;
    /**
     * 商品数量
     */
    private Integer cnt;
    /**
     * 支付自增码
     */
    private Long pid;
    /**
     * 线下支付金额
     */
    private BigDecimal otherAmount;
    /**
     * 订单备注
     */
    private String description;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "phone_number")
    public String getPhoneNumber() {
        return phoneNumber;
    }


    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Column(name = "user_name")
    public String getUserName() {
        return userName;
    }


    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name = "pay_no")
    public String getPayNo() {
        return payNo;
    }


    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    @Column(name = "orders_no")
    public String getOrdersNo() {
        return ordersNo;
    }


    public void setOrdersNo(String ordersNo) {
        this.ordersNo = ordersNo;
    }

    @Column(name = "product")
    public String getProduct() {
        return product;
    }


    public void setProduct(String product) {
        this.product = product;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "pay_amount")
    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "way")
    public Integer getWay() {
        return way;
    }


    public void setWay(Integer way) {
        this.way = way;
    }

    @Column(name = "pay_at")
    public Long getPayAt() {
        return payAt;
    }


    public void setPayAt(Long payAt) {
        this.payAt = payAt;
    }

    @Column(name = "order_at")
    public Long getOrderAt() {
        return orderAt;
    }


    public void setOrderAt(Long orderAt) {
        this.orderAt = orderAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    @Column(name = "goods_id")
    public Long getGoodsId() {
        return goodsId;
    }


    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    @Column(name = "order_type")
    public Integer getOrderType() {
        return orderType;
    }


    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "time_out_at")
    public Long getTimeOutAt() {
        return timeOutAt;
    }

    public void setTimeOutAt(Long timeOutAt) {
        this.timeOutAt = timeOutAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }


    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }


    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "delivery_at")
    public Long getDeliveryAt() {
        return deliveryAt;
    }

    public void setDeliveryAt(Long deliveryAt) {
        this.deliveryAt = deliveryAt;
    }

    @Column(name = "receive_at")
    public Long getReceiveAt() {
        return receiveAt;
    }

    public void setReceiveAt(Long receiveAt) {
        this.receiveAt = receiveAt;
    }

    @Column(name = "express_amount")
    public String getExpressAmount() {
        return expressAmount;
    }

    public void setExpressAmount(String expressAmount) {
        this.expressAmount = expressAmount;
    }

    @Column(name = "orders_way")
    public Integer getOrdersWay() {
        return ordersWay;
    }

    public void setOrdersWay(Integer ordersWay) {
        this.ordersWay = ordersWay;
    }

    @Column(name = "pay_rand")
    public Integer getPayRand() {
        return payRand;
    }

    public void setPayRand(Integer payRand) {
        this.payRand = payRand;
    }

    @Column(name = "cnt")
    public Integer getCnt() {
        return cnt;
    }

    public void setCnt(Integer cnt) {
        this.cnt = cnt;
    }

    @Column(name = "pid")
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Column(name = "sys_receive_at")
    public Long getSysReceiveAt() {
        return sysReceiveAt;
    }

    public void setSysReceiveAt(Long sysReceiveAt) {
        this.sysReceiveAt = sysReceiveAt;
    }

    @Column(name = "other_amount")
    public BigDecimal getOtherAmount() {
        return otherAmount;
    }

    public void setOtherAmount(BigDecimal otherAmount) {
        this.otherAmount = otherAmount;
    }

    @Column(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

