/**
 * 
 */
package com.ptteng.sca.fans.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.fans.common.model.OrdersInfo;
import com.ptteng.fans.common.service.OrdersInfoService;

import java.util.List;
import java.util.Map;

public class OrdersInfoSCAClient implements OrdersInfoService {

    private OrdersInfoService ordersInfoService;

	public OrdersInfoService getOrdersInfoService() {
		return ordersInfoService;
	}
	
	
	public void setOrdersInfoService(OrdersInfoService ordersInfoService) {
		this.ordersInfoService =ordersInfoService;
	}
	
	
			   
		@Override
		public Long insert(OrdersInfo ordersInfo)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.insert(ordersInfo);
		          
		
		}	
		  
    	   
		@Override
		public List<OrdersInfo> insertList(List<OrdersInfo> ordersInfoList)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.insertList(ordersInfoList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(OrdersInfo ordersInfo)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.update(ordersInfo);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<OrdersInfo> ordersInfoList)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.updateList(ordersInfoList);
		          
		
		}	
		  
    	   
		@Override
		public OrdersInfo getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<OrdersInfo> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersInfoIdByOrdersId(Long ordersId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.getOrdersInfoIdByOrdersId(ordersId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersInfoIdsByBizIdAndBizType(Long bizId,Integer bizType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.getOrdersInfoIdsByBizIdAndBizType(bizId,bizType,start,limit);
	
	
	}

	@Override
	public Long getBizIdByOrdersId(Long ordersId) throws ServiceException, ServiceDaoException {
		return ordersInfoService.getBizIdByOrdersId( ordersId);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersInfoIdsByBizIdAndBizType(Long bizId,Integer bizType)throws ServiceException, ServiceDaoException{
		
		return ordersInfoService.countOrdersInfoIdsByBizIdAndBizType(bizId,bizType);
	
	
	}
	
		
	
		@Override
	public List<Long> getOrdersInfoIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersInfoService.getOrdersInfoIds(start, limit);
	}

	@Override
	public Integer countOrdersInfoIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersInfoService.countOrdersInfoIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersInfoService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersInfoService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   ordersInfoService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.ordersInfoService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}

    @Override
    public Object getMapListByDynamicCondition(Class clz,Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return this.ordersInfoService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

