package com.ptteng.fans.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.fans.common.model.Production;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface ProductionService extends BaseDaoService {


  public Long insert(Production production) throws ServiceException, ServiceDaoException;


  public List<Production> insertList(List<Production> productionList)
      throws ServiceException, ServiceDaoException;


  public boolean delete(Long id) throws ServiceException, ServiceDaoException;


  public boolean update(Production production) throws ServiceException, ServiceDaoException;


  public boolean updateList(List<Production> productionList)
      throws ServiceException, ServiceDaoException;


  public Production getObjectById(Long id) throws ServiceException, ServiceDaoException;


  public List<Production> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException;


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getProductionIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;

  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countProductionIds() throws ServiceException, ServiceDaoException;


}

