/**
 *
 */
package com.ptteng.sca.fans.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.fans.common.model.Production;
import com.ptteng.fans.common.service.ProductionService;
import java.util.List;
import java.util.Map;

public class ProductionSCAClient implements ProductionService {

  private ProductionService productionService;

  public ProductionService getProductionService() {
    return productionService;
  }


  public void setProductionService(ProductionService productionService) {
    this.productionService = productionService;
  }


  @Override
  public Long insert(Production production) throws ServiceException, ServiceDaoException {

    return productionService.insert(production);


  }


  @Override
  public List<Production> insertList(List<Production> productionList)
      throws ServiceException, ServiceDaoException {

    return productionService.insertList(productionList);


  }


  @Override
  public boolean delete(Long id) throws ServiceException, ServiceDaoException {

    return productionService.delete(id);


  }


  @Override
  public boolean update(Production production) throws ServiceException, ServiceDaoException {

    return productionService.update(production);


  }


  @Override
  public boolean updateList(List<Production> productionList)
      throws ServiceException, ServiceDaoException {

    return productionService.updateList(productionList);


  }


  @Override
  public Production getObjectById(Long id) throws ServiceException, ServiceDaoException {

    return productionService.getObjectById(id);


  }


  @Override
  public List<Production> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException {

    return productionService.getObjectsByIds(ids);


  }


  @Override
  public List<Long> getProductionIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return productionService.getProductionIds(start, limit);
  }

  @Override
  public Integer countProductionIds() throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return productionService.countProductionIds();
  }


  @Override
  public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions,
      Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return productionService.getIdsByDynamicCondition(clz, conditions, start, limit);
  }


  @Override
  public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return productionService.fakeDelete(clz, id);
  }


  @Override
  public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
    productionService.deleteList(clz, ids);

  }

  @Override
  public Object getObjectByDynamicCondition(Class clz,
      Map<String, Object> conditions, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    return this.productionService.getObjectByDynamicCondition(clz, conditions, start, limit);
  }


}

