/**
 * 
 */
package com.ptteng.sca.fans.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.fans.common.model.Orders;
import com.ptteng.fans.common.service.OrdersService;
import java.util.List;
import java.util.Map;

public class OrdersSCAClient implements OrdersService {

    private OrdersService ordersService;

	public OrdersService getOrdersService() {
		return ordersService;
	}
	
	
	public void setOrdersService(OrdersService ordersService) {
		this.ordersService =ordersService;
	}
	
	
			   
		@Override
		public Long insert(Orders orders)throws ServiceException, ServiceDaoException{
		
		return ordersService.insert(orders);
		          
		
		}	
		  
    	   
		@Override
		public List<Orders> insertList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{
		
		return ordersService.insertList(ordersList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Orders orders)throws ServiceException, ServiceDaoException{
		
		return ordersService.update(orders);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{
		
		return ordersService.updateList(ordersList);
		          
		
		}	
		  
    	   
		@Override
		public Orders getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return ordersService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Orders> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return ordersService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdsByType(type,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrdersIdByPayNo(String payNo)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdByPayNo(payNo);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrdersIdByOrdersNo(String ordersNo)throws ServiceException, ServiceDaoException{
		
		return ordersService.getOrdersIdByOrdersNo(ordersNo);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		return ordersService.countOrdersIdsByType(type);
	
	
	}
	
		
	
		@Override
	public List<Long> getOrdersIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.getOrdersIds(start, limit);
	}

	@Override
	public Integer countOrdersIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.countOrdersIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return ordersService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   ordersService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.ordersService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

