package com.ptteng.fans.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.fans.common.model.Contents;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface ContentsService extends BaseDaoService {

	



   		   
		
		public Long insert(Contents contents)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Contents> insertList(List<Contents> contentsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Contents contents)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Contents> contentsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Contents getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Contents> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByType(Integer type)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByType(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId,
      Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getContentsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countContentsIds() throws ServiceException, ServiceDaoException;
	

}

