/**
 *
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.Sms;
import com.ptteng.employment.common.service.SmsService;

import java.util.List;
import java.util.Map;

public class SmsSCAClient implements SmsService {

    private SmsService smsService;

    public SmsService getSmsService() {
        return smsService;
    }


    public void setSmsService(SmsService smsService) {
        this.smsService = smsService;
    }


    @Override
    public Long insert(Sms sms) throws ServiceException, ServiceDaoException {

        return smsService.insert(sms);


    }


    @Override
    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException {

        return smsService.insertList(smsList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return smsService.delete(id);


    }


    @Override
    public boolean update(Sms sms) throws ServiceException, ServiceDaoException {

        return smsService.update(sms);


    }


    @Override
    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException {

        return smsService.updateList(smsList);


    }


    @Override
    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return smsService.getObjectById(id);


    }


    @Override
    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return smsService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException {

        return smsService.getSmsIdByMobileAndType(mobile, type);


    }

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getSmsIdByEmailAndType(String email, String type) throws ServiceException, ServiceDaoException {

        return smsService.getSmsIdByEmailAndType(email, type);


    }


    @Override
    public List<Long> getSmsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return smsService.getSmsIds(start, limit);
    }

    @Override
    public Integer countSmsIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return smsService.countSmsIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return smsService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return smsService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return smsService.getMapListByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return smsService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        smsService.deleteList(clz, ids);

    }

    @Override
    public String sendMsg(String phone, String type) throws ServiceException,
            ServiceDaoException {
        // TODO Auto-generated method stub
        return smsService.sendMsg(phone, type);
    }

    @Override
    public String sendProjectMsg(String phone, String projectCode) throws ServiceException, ServiceDaoException {
        return smsService.sendProjectMsg(phone, projectCode);
    }

    @Override
    public String sendSignMsg(String phone, String userName, String customerName) throws ServiceException, ServiceDaoException {
        return smsService.sendSignMsg(phone, userName,customerName);
    }


    @Override
    public String sendVoice(String phone, String type) throws ServiceException, ServiceDaoException {
        return smsService.sendVoice(phone, type);
    }

    @Override
    public String sendEmail(String email, String type) throws ServiceException, ServiceDaoException {
        return smsService.sendEmail(email, type);
    }

    @Override
    public String sendEmailByParams(String email, String type, String[] params) throws ServiceException, ServiceDaoException {
        return smsService.sendEmailByParams(email, type,params);
    }
}

