/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Dict;
import com.ptteng.employment.common.service.DictService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class DictSCAClient implements DictService {

    private DictService dictService;

    public DictService getDictService() {
        return dictService;
    }


    public void setDictService(DictService dictService) {
        this.dictService = dictService;
    }


    @Override
    public Long insert(Dict dict) throws ServiceException, ServiceDaoException {

        return dictService.insert(dict);


    }


    @Override
    public List<Dict> insertList(List<Dict> dictList) throws ServiceException, ServiceDaoException {

        return dictService.insertList(dictList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return dictService.delete(id);


    }


    @Override
    public boolean update(Dict dict) throws ServiceException, ServiceDaoException {

        return dictService.update(dict);


    }


    @Override
    public boolean updateList(List<Dict> dictList) throws ServiceException, ServiceDaoException {

        return dictService.updateList(dictList);


    }


    @Override
    public Dict getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return dictService.getObjectById(id);


    }


    @Override
    public List<Dict> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return dictService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDictIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return dictService.getDictIdsByName(name, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getDictIdByNameAndType(String name, String type) throws ServiceException, ServiceDaoException {

        return dictService.getDictIdByNameAndType(name, type);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDictIdsByName(String name) throws ServiceException, ServiceDaoException {

        return dictService.countDictIdsByName(name);


    }


    @Override
    public List<Long> getDictIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return dictService.getDictIds(start, limit);
    }

    @Override
    public Integer countDictIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return dictService.countDictIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return dictService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return dictService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        dictService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.dictService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.dictService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

