/**
 *
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.CustomerRole;
import com.ptteng.employment.common.service.CustomerRoleService;
import org.osoa.sca.annotations.Reference;

import java.util.List;
import java.util.Map;

public class CustomerRoleSCAClient implements CustomerRoleService {

    private CustomerRoleService customerRoleService;

    public CustomerRoleService getCustomerRoleService() {
        return customerRoleService;
    }

    @Reference
    public void setCustomerRoleService(CustomerRoleService customerRoleService) {
        this.customerRoleService = customerRoleService;
    }

    @Override
    public Long insert(CustomerRole role) throws ServiceException, ServiceDaoException {

        return customerRoleService.insert(role);

    }

    @Override
    public List<CustomerRole> insertList(List<CustomerRole> roleList) throws ServiceException,
            ServiceDaoException {

        return customerRoleService.insertList(roleList);

    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return customerRoleService.delete(id);

    }

    @Override
    public boolean update(CustomerRole role) throws ServiceException,
            ServiceDaoException {

        return customerRoleService.update(role);

    }

    @Override
    public boolean updateList(List<CustomerRole> roleList) throws ServiceException,
            ServiceDaoException {

        return customerRoleService.updateList(roleList);

    }

    @Override
    public CustomerRole getObjectById(Long id) throws ServiceException,
            ServiceDaoException {

        return customerRoleService.getObjectById(id);

    }

    @Override
    public List<CustomerRole> getObjectsByIds(List<Long> ids) throws ServiceException,
            ServiceDaoException {

        return customerRoleService.getObjectsByIds(ids);

    }

    @Override
    public List<Long> getCustomerRoleIdsByName(String name, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleService.getCustomerRoleIdsByName(name, start, limit);
    }

    @Override
    public List<Long> getCustomerRoleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleService.getCustomerRoleIds(start, limit);
    }

    @Override
    public Integer countCustomerRoleIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleService.countCustomerRoleIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return customerRoleService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return customerRoleService.getMapListByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        customerRoleService.deleteList(clz, ids);

    }


}

