package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "project")
public class Project implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2099690064287584256L;


    /**
     * 进行中
     */
    public static final Integer STATUS_IN_PROGRESS = 2;

    /**
     * 已完成
     */
    public static final Integer STATUS_COMPLETED = 4;
    /**
     * 正在支付
     */
    public static final Integer STATUS_PAYING = 6;
    /**
     * 支付失败
     */
    public static final Integer STATUS_PAY_FAIL = 7;
    /**
     * 未发布
     */
    public static final Integer STATUS_UNPUBULISH = 5;

    /**
     * 待支付
     */
    public static final Integer STATUS_TO_BE_PAID = 3;

    /**
     * 已取消
     */
    public static final Integer STATUS_CANCELED = -1;

    /**
     * 已驳回
     */
    public static final Integer STATUS_REJECTED = 0;

    /**
     * 审核中
     */
    public static final Integer STATUS_REVIEWING = 1;
    /**
     * 未开票
     */
    public static final Integer INVOICE_STATUS_NOT = 0; /**
    /**
     * 未审核
     */
    public static final Integer INVOICE_STATUS_CHECK = 1; /**
    /**
     * 开具中
     */
    public static final Integer INVOICE_STATUS_PASS = 2; /**
     * 已开票
     */
    public static final Integer INVOICE_STATUS_TRUE = 3;



    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 项目类型（发票类目）
     */
    private String invoiceCategory;

    /**
     * 项目类型（发票类目）
     */
    private Long invoiceCategoryId;


    /**
     * 服务商id
     */
    private Long serviceProviderId;

    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 项目名
     */
    private String name;


    /**
     * 实际支付金额
     */
    private BigDecimal actualAmount;

    /**
     * 零客项目金额
     */
    private BigDecimal projectAmount;


    /**
     * 项目预估金额
     */
    private BigDecimal estimatedAmount;


    /**
     * 开始时间
     */
    private Long startTime;


    /**
     * 结束时间
     */
    private Long endTime;


    /**
     * 项目总耗时
     */
    private Long duration;


    /**
     * 零客选择
     */
    private Integer userType;


    /**
     * 项目代码
     */
    private String projectCode;


    /**
     * 项目描述
     */
    private String projectDesc;


    /**
     * 人数区间说明
     */
    private String numDesc;


    /**
     * 验收标准
     */
    private String acceptanceDesc;


    /**
     * 结算规则
     */
    private String settlementDesc;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 人员要求说明
     */
    private String userDesc;


    /**
     * 总人数
     */
    private Integer userTotal;


    /**
     * 协议文件
     */
    private String agreementUrl;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 支付时间
     */
    private Long payTime;
    /**
     * 完成时间
     */
    private Long completedTime;


    /**
     * 审核人
     */
    private Long reviewBy;


    /**
     * 审核时间
     */
    private Long reviewTime;


    /**
     * 验收时间
     */
    private Long receptionTime;


    /**
     * 验收人
     */
    private Long receptionBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 开票状态
     */
    private Integer invoiceStatus;
    /**
     * 展示状态
     */
    private Integer showStatus;
    /**
     * 支付订单uuid
     */
    private String orderUUID;
    /**
     * 支付订单状态
     */
    private Integer orderStatus;
    /**
     * 评价平均分
     */
    private BigDecimal score;
    /**
     * 评价数量
     */
    private Integer commentTotal;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "invoice_category")
    public String getInvoiceCategory() {
        return invoiceCategory;
    }


    public void setInvoiceCategory(String invoiceCategory) {
        this.invoiceCategory = invoiceCategory;
    }

    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }


    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "actual_amount")
    public BigDecimal getActualAmount() {
        return actualAmount;
    }


    public void setActualAmount(BigDecimal actualAmount) {
        this.actualAmount = actualAmount;
    }

    @Column(name = "estimated_amount")
    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }


    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    @Column(name = "start_time")
    public Long getStartTime() {
        return startTime;
    }


    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Column(name = "end_time")
    public Long getEndTime() {
        return endTime;
    }


    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Column(name = "duration")
    public Long getDuration() {
        return duration;
    }


    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Column(name = "user_type")
    public Integer getUserType() {
        return userType;
    }


    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Column(name = "project_code")
    public String getProjectCode() {
        return projectCode;
    }


    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @Column(name = "project_desc")
    public String getProjectDesc() {
        return projectDesc;
    }


    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc;
    }

    @Column(name = "num_desc")
    public String getNumDesc() {
        return numDesc;
    }


    public void setNumDesc(String numDesc) {
        this.numDesc = numDesc;
    }

    @Column(name = "acceptance_desc")
    public String getAcceptanceDesc() {
        return acceptanceDesc;
    }


    public void setAcceptanceDesc(String acceptanceDesc) {
        this.acceptanceDesc = acceptanceDesc;
    }

    @Column(name = "settlement_desc")
    public String getSettlementDesc() {
        return settlementDesc;
    }


    public void setSettlementDesc(String settlementDesc) {
        this.settlementDesc = settlementDesc;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "user_desc")
    public String getUserDesc() {
        return userDesc;
    }


    public void setUserDesc(String userDesc) {
        this.userDesc = userDesc;
    }

    @Column(name = "user_total")
    public Integer getUserTotal() {
        return userTotal;
    }


    public void setUserTotal(Integer userTotal) {
        this.userTotal = userTotal;
    }

    @Column(name = "agreement_url")
    public String getAgreementUrl() {
        return agreementUrl;
    }


    public void setAgreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "pay_time")
    public Long getPayTime() {
        return payTime;
    }


    public void setPayTime(Long payTime) {
        this.payTime = payTime;
    }

    @Column(name = "review_by")
    public Long getReviewBy() {
        return reviewBy;
    }


    public void setReviewBy(Long reviewBy) {
        this.reviewBy = reviewBy;
    }

    @Column(name = "review_time")
    public Long getReviewTime() {
        return reviewTime;
    }


    public void setReviewTime(Long reviewTime) {
        this.reviewTime = reviewTime;
    }

    @Column(name = "reception_time")
    public Long getReceptionTime() {
        return receptionTime;
    }


    public void setReceptionTime(Long receptionTime) {
        this.receptionTime = receptionTime;
    }

    @Column(name = "reception_by")
    public Long getReceptionBy() {
        return receptionBy;
    }


    public void setReceptionBy(Long receptionBy) {
        this.receptionBy = receptionBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @Column(name = "invoice_status")
    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }
    @Transient
    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }
    @Column(name = "order_uuid")
    public String getOrderUUID() {
        return orderUUID;
    }

    public void setOrderUUID(String orderUUID) {
        this.orderUUID = orderUUID;
    }
    @Column(name = "order_status")
    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }
    @Column(name = "project_amount")
    public BigDecimal getProjectAmount() {
        return projectAmount;
    }

    public void setProjectAmount(BigDecimal projectAmount) {
        this.projectAmount = projectAmount;
    }
    @Column(name = "invoice_category_id")
    public Long getInvoiceCategoryId() {
        return invoiceCategoryId;
    }

    public void setInvoiceCategoryId(Long invoiceCategoryId) {
        this.invoiceCategoryId = invoiceCategoryId;
    }
    @Column(name = "score")
    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }
    @Column(name = "comment_total")
    public Integer getCommentTotal() {
        return commentTotal;
    }

    public void setCommentTotal(Integer commentTotal) {
        this.commentTotal = commentTotal;
    }
    @Column(name = "completed_time")
    public Long getCompletedTime() {
        return completedTime;
    }

    public void setCompletedTime(Long completedTime) {
        this.completedTime = completedTime;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

