package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "customer_rate_item")
public class CustomerRateItem implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6570392739463514112L;


    /**
     * 单人单月费率
     */
    public static final Integer RATE_TYPE_USER = 1;

    /**
     * 企业单月费率
     */
    public static final Integer RATE_TYPE_COMPANY = 2;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 客户费率id
     */
    private Long customerRateId;


    /**
     * 上限值
     */
    private BigDecimal upperLimit;


    /**
     * 下限值
     */
    private BigDecimal lowerLimit;


    /**
     * 费率
     */
    private BigDecimal rate;


    /**
     * 费率类型
     */
    private Integer rateType;
    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "customer_rate_id")
    public Long getCustomerRateId() {
        return customerRateId;
    }


    public void setCustomerRateId(Long customerRateId) {
        this.customerRateId = customerRateId;
    }

    @Column(name = "upper_limit")
    public BigDecimal getUpperLimit() {
        return upperLimit;
    }


    public void setUpperLimit(BigDecimal upperLimit) {
        this.upperLimit = upperLimit;
    }

    @Column(name = "lower_limit")
    public BigDecimal getLowerLimit() {
        return lowerLimit;
    }


    public void setLowerLimit(BigDecimal lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Column(name = "rate")
    public BigDecimal getRate() {
        return rate;
    }


    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    @Column(name = "rate_type")
    public Integer getRateType() {
        return rateType;
    }


    public void setRateType(Integer rateType) {
        this.rateType = rateType;
    }
    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

