package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "contract")
public class Contract implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2752860552990698496L;


    /**
     * 企业平台协议
     */
    public static final Integer TYPE_CUSTOMER_PLATFORM = 1;

    /**
     * 企业项目协议
     */
    public static final Integer TYPE_CUSTOMER_PROJECT = 2;

    /**
     * 用户平台协议
     */
    public static final Integer TYPE_INDIVIDUAL_USER_PLATFORM = 3;

    /**
     * 用户项目协议
     */
    public static final Integer TYPE_INDIVIDUAL_USER_PROJECT = 4;
    //合同状态
    public static final Integer STATUS_IN_UN_START = 1;
    public static final Integer STATUS_IN_PROCESS = 2;
    public static final Integer STATUS_IN_FINISH = 3;
    //合同文件状态
    //0-文件未上传；
    //
    //1-文件上传中 ；
    //
    //2-文件上传已完成,；
    //
    //3-文件上传失败 ；
    //
    //4-文件等待转pdf ；
    //
    //5-文件已转换pdf ；
    //
    //6-加水印中；
    //
    //7-加水印完毕；
    //
    //8-文件转换中；
    //
    //9-文件转换失败
    public static final Integer FILE_STATUS_PDF = 5;
    public static final Integer FILE_STATUS_NO = 0;
    public static final Integer FILE_STATUS_UPLOADING = 1;
    public static final Integer FILE_STATUS_UPLOAD_FAIL = 3;
    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 零客id
     */
    private Long userId;
    /**
     * 服务商id
     */
    private Long serviceProviderId;


    /**
     * 合同编号
     */
    private String contractNumber;


    /**
     * 合同类型
     */
    private Integer type;


    /**
     * 甲方
     */
    private String partyA;


    /**
     * 乙方
     */
    private String partyB;


    /**
     * 项目id
     */
    private Long projectId;


    /**
     * 项目名
     */
    private String projectName;


    /**
     * 项目单号
     */
    private String projectCode;


    /**
     * 合同地址
     */
    private String url;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 文件id
     */
    private String fileId;

    /**
     * 流程id
     */
    private String flowId;
    /**
     * 文件名
     */
    private String fileName;

    /**
     * 流程id
     */
    private Integer status;
    /**
     * 信息
     */
    private String message;
    /**
     * 上传状态
     */
    private Integer fileStatus;



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "contract_number")
    public String getContractNumber() {
        return contractNumber;
    }


    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "party_a")
    public String getPartyA() {
        return partyA;
    }


    public void setPartyA(String partyA) {
        this.partyA = partyA;
    }

    @Column(name = "party_b")
    public String getPartyB() {
        return partyB;
    }


    public void setPartyB(String partyB) {
        this.partyB = partyB;
    }

    @Column(name = "project_id")
    public Long getProjectId() {
        return projectId;
    }


    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Column(name = "project_name")
    public String getProjectName() {
        return projectName;
    }


    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Column(name = "project_code")
    public String getProjectCode() {
        return projectCode;
    }


    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "file_id")
    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }
    @Column(name = "flow_id")
    public String getFlowId() {
        return flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    @Column(name = "file_name")
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }

    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }
    @Column(name = "message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
    @Column(name = "file_status")
    public Integer getFileStatus() {
        return fileStatus;
    }

    public void setFileStatus(Integer fileStatus) {
        this.fileStatus = fileStatus;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

