/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.ProjectResult;
import com.ptteng.employment.common.service.ProjectResultService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ProjectResultSCAClient implements ProjectResultService {

    private ProjectResultService projectResultService;

    public ProjectResultService getProjectResultService() {
        return projectResultService;
    }


    public void setProjectResultService(ProjectResultService projectResultService) {
        this.projectResultService = projectResultService;
    }


    @Override
    public Long insert(ProjectResult projectResult) throws ServiceException, ServiceDaoException {

        return projectResultService.insert(projectResult);


    }


    @Override
    public List<ProjectResult> insertList(List<ProjectResult> projectResultList) throws ServiceException, ServiceDaoException {

        return projectResultService.insertList(projectResultList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return projectResultService.delete(id);


    }


    @Override
    public boolean update(ProjectResult projectResult) throws ServiceException, ServiceDaoException {

        return projectResultService.update(projectResult);


    }


    @Override
    public boolean updateList(List<ProjectResult> projectResultList) throws ServiceException, ServiceDaoException {

        return projectResultService.updateList(projectResultList);


    }


    @Override
    public ProjectResult getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return projectResultService.getObjectById(id);


    }


    @Override
    public List<ProjectResult> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return projectResultService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getProjectResultIdsByProjectId(Long projectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return projectResultService.getProjectResultIdsByProjectId(projectId, start, limit);


    }

    @Override
    public List<Long> getProjectResultIdsByProjectIdAndUserId(Long projectId, Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return projectResultService.getProjectResultIdsByProjectIdAndUserId(projectId, userId, start, limit);
    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countProjectResultIdsByProjectId(Long projectId) throws ServiceException, ServiceDaoException {

        return projectResultService.countProjectResultIdsByProjectId(projectId);


    }


    @Override
    public List<Long> getProjectResultIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectResultService.getProjectResultIds(start, limit);
    }

    @Override
    public Integer countProjectResultIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectResultService.countProjectResultIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectResultService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectResultService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        projectResultService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectResultService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectResultService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

