package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.CustomerManager;
import org.osoa.sca.annotations.Remotable;

import java.util.List;
import java.util.Map;

@Remotable
public interface CustomerManagerService extends BaseDaoService {


    public Long insert(CustomerManager manager) throws ServiceException,
            ServiceDaoException;

    public List<CustomerManager> insertList(List<CustomerManager> managerList)
            throws ServiceException, ServiceDaoException;

    public boolean delete(Long id) throws ServiceException, ServiceDaoException;

    public boolean update(CustomerManager manager) throws ServiceException,
            ServiceDaoException;

    public boolean updateList(List<CustomerManager> managerList) throws ServiceException,
            ServiceDaoException;

    public CustomerManager getObjectById(Long id) throws ServiceException,
            ServiceDaoException;

    public List<CustomerManager> getObjectsByIds(List<Long> ids) throws ServiceException,
            ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIdsByName(String name, Integer start,
                                          Integer limit) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIdsByNameAndCustomerId(String name,Long customerId, Integer start,
                                          Integer limit) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIdsByRoleID(Long roleID, Integer start,
                                            Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIdsByRoleIDAndStatus(Long roleID, String status, Integer start,
                                                     Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerManagerIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerManagerIdsByCondition(Map<String, Object> conditions,
                                               Integer start, Integer limit) throws ServiceException,
            ServiceDaoException;

}

