package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "invoice_category")
public class InvoiceCategory implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1425246065439009792L;


    /**
     * 普票
     */
    public static final Integer TYPE_COMMON = 1;

    /**
     * 专票
     */
    public static final Integer TYPE_SPECIAL = 2;

    /**
     * 差额票
     */
    public static final Integer TYPE_BALANCE = 3;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 服务商ID
     */
    private Long serviceProviderId;


    /**
     * 发票类目
     */
    private String category;


    /**
     * 发票类型
     */
    private String type;


    /**
     * 税率
     */
    private String rate;


    /**
     * 备注
     */
    private String remarks;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }


    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Column(name = "category")
    public String getCategory() {
        return category;
    }


    public void setCategory(String category) {
        this.category = category;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }


    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "rate")
    public String getRate() {
        return rate;
    }


    public void setRate(String rate) {
        this.rate = rate;
    }

    @Column(name = "remarks")
    public String getRemarks() {
        return remarks;
    }


    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

