package com.ptteng.employment.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "customer")
public class Customer implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 9192049708417113088L;


    /**
     * 停用
     */
    public static final Integer STATUS_UNUSED = -1;
    /**
     * 停用
     */
    public static final Integer STATUS_DISABLE = 0;

    /**
     * 启用
     */
    public static final Integer STATUS_ENABLE = 1;

    /**
     * 通过
     */
    public static final Integer VERIFY_STATUS_TRUE = 1;

    /**
     * 未通过
     */
    public static final Integer VERIFY_STATUS_FAIL = 0;
    /**
     * 黑白名单状态
     */
    public static final Integer WHITE_LIST_WHITE = 1;
    public static final Integer WHITE_LIST_NONE = 0;
    public static final Integer WHITE_LIST_BLACK = -1;
    public static final Integer USE_SMS_TRUE = 1;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 企业名称
     */
    private String name;


    /**
     * 信用代码
     */
    private String creditCode;


    /**
     * 法人姓名
     */
    private String legalPersonName;


    /**
     * 联系方式
     */
    private String mobile;


    /**
     * 邮箱
     */
    private String email;


    /**
     * 营业执照
     */
    private String businessLicense;


    /**
     * 办公照片
     */
    private String officePhotos;


    /**
     * 联系地址
     */
    private String address;


    /**
     * 入网申请表
     */
    private String applicationForm;


    /**
     * 合同
     */
    private String contract;


    /**
     * 企业号
     */
    private String customerNo;


    /**
     * 状态
     */
    private Integer status;
    /**
     * 白名单
     */
    private Integer whiteList;
    /**
     * 白名单时间
     */
    private Long whiteListAt;


    /**
     * 核验状态
     */
    private Integer verifyStatus;
    /**
     * 纳税人类型
     */
    private Integer taxpayerType;

    private String pwd;

    /**
     * 代理商id
     */
    private Long agentProviderId;

    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * e签宝账号id
     */
    private String esignAccountId;
    /**
     * e签宝印章id
     */
    private String esignSealId;
    /**
     * 辛巴达uuid
     */
    private String xinbadaUserUUID;
    /**
     * 辛巴达token
     */
    private String xinbadaToken;

    private String platform;
    private Integer useSms;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "credit_code")
    public String getCreditCode() {
        return creditCode;
    }


    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    @Column(name = "legal_person_name")
    public String getLegalPersonName() {
        return legalPersonName;
    }


    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "email")
    public String getEmail() {
        return email;
    }


    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name = "business_license")
    public String getBusinessLicense() {
        return businessLicense;
    }


    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    @Column(name = "office_photos")
    public String getOfficePhotos() {
        return officePhotos;
    }


    public void setOfficePhotos(String officePhotos) {
        this.officePhotos = officePhotos;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "application_form")
    public String getApplicationForm() {
        return applicationForm;
    }


    public void setApplicationForm(String applicationForm) {
        this.applicationForm = applicationForm;
    }

    @Column(name = "contract")
    public String getContract() {
        return contract;
    }


    public void setContract(String contract) {
        this.contract = contract;
    }

    @Column(name = "customer_no")
    public String getCustomerNo() {
        return customerNo;
    }


    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "verify_status")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }


    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @Column(name = "agent_provider_id")
    public Long getAgentProviderId() {
        return agentProviderId;
    }


    public void setAgentProviderId(Long agentProviderId) {
        this.agentProviderId = agentProviderId;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "taxpayer_type")
    public Integer getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }
    @Transient
    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
    @Column(name = "white_list")
    public Integer getWhiteList() {
        return whiteList;
    }

    public void setWhiteList(Integer whiteList) {
        this.whiteList = whiteList;
    }
    @Column(name = "white_list_at")
    public Long getWhiteListAt() {
        return whiteListAt;
    }

    public void setWhiteListAt(Long whiteListAt) {
        this.whiteListAt = whiteListAt;
    }
    @Column(name = "esign_account_id")
    public String getEsignAccountId() {
        return esignAccountId;
    }

    public void setEsignAccountId(String esignAccountId) {
        this.esignAccountId = esignAccountId;
    }
    @Column(name = "esign_seal_id")
    public String getEsignSealId() {
        return esignSealId;
    }

    public void setEsignSealId(String esignSealId) {
        this.esignSealId = esignSealId;
    }
    @Column(name = "xinbada_user_uuid")
    public String getXinbadaUserUUID() {
        return xinbadaUserUUID;
    }

    public void setXinbadaUserUUID(String xinbada_user_uuid) {
        this.xinbadaUserUUID = xinbada_user_uuid;
    }
    @Column(name = "xinbada_token")
    public String getXinbadaToken() {
        return xinbadaToken;
    }

    public void setXinbadaToken(String xinbada_token) {
        this.xinbadaToken = xinbada_token;
    }
    @Column(name = "platform")
    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }
    @Column(name = "use_sms")
    public Integer getUseSms() {
        return useSms;
    }

    public void setUseSms(Integer useSms) {
        this.useSms = useSms;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

