package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "account")
public class Account implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2485103236966133760L;	
	
		
	/**
	 *  禁用
	 * 
	 */
	public static final Integer ACCOUNT_STATUS_OFF = 0;
    	
	/**
	 *  启用
	 * 
	 */
	public static final Integer ACCOUNT_STATUS_ON = 1;
	/**
	 *  LINGCAI
	 *
	 */
	public static final String ACCOUNT_TYPE_LINGCAI = "LINGCAI";
	public static final String ACCOUNT_TYPE_XINBADA = "XINBADA";

   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  账户号
   *
   */
    private  String account;
   /**
   *
   *服务商编号(灵才)
   */
    private  String zoneId;

   /**
   *
   *服务商编号(薪八达)
   */
    private  String serverUserUUID;
   /**
   *
   *账户UUID(薪八达)
   */
    private  String customerAccountUUID;

   /**
   *  账户类型
   *
   */
    private  String accountType;
   /**
   *  账户名
   *
   */
    private  String accountName;

  
   /**
   *  客户名
   *
   */
    private  String customerName;
	
  
   /**
   *  客户id
   *
   */
    private  Long customerId;
	
  
   /**
   *  服务商名
   *
   */
    private  String serviceProviderName;
	
  
   /**
   *  服务商id
   *
   */
    private  Long serviceProviderId;
	
  
   /**
   *  总余额
   *
   */
    private BigDecimal balanceTotal;
	
  
   /**
   *  可用余额
   *
   */
    private  BigDecimal balanceAvailable;
   /**
   *  待结算金额
   *
   */
    private  BigDecimal balanceTobeSettled;

  
   /**
   *  账户状态
   *
   */
    private  Integer accountStatus;
	
  
   /**
   *  银行名
   *
   */
    private  String bankName;
	
  
   /**
   *  银行代码
   *
   */
    private  String bankCode;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "account")
	public String getAccount() {
		return account;
	}
	
	
	public void setAccount(String account) {
		this.account = account;
	}
		 	@Column(name = "customer_name")
	public String getCustomerName() {
		return customerName;
	}
	
	
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
		 	@Column(name = "customer_id")
	public Long getCustomerId() {
		return customerId;
	}
	
	
	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}
		 	@Column(name = "service_provider_name")
	public String getServiceProviderName() {
		return serviceProviderName;
	}
	
	
	public void setServiceProviderName(String serviceProviderName) {
		this.serviceProviderName = serviceProviderName;
	}
		 	@Column(name = "service_provider_id")
	public Long getServiceProviderId() {
		return serviceProviderId;
	}
	
	
	public void setServiceProviderId(Long serviceProviderId) {
		this.serviceProviderId = serviceProviderId;
	}
		 	@Column(name = "balance_total")
	public BigDecimal getBalanceTotal() {
		return balanceTotal;
	}
	
	
	public void setBalanceTotal(BigDecimal balanceTotal) {
		this.balanceTotal = balanceTotal;
	}
		 	@Column(name = "balance_available")
	public BigDecimal getBalanceAvailable() {
		return balanceAvailable;
	}
	
	
	public void setBalanceAvailable(BigDecimal balanceAvailable) {
		this.balanceAvailable = balanceAvailable;
	}
		 	@Column(name = "account_status")
	public Integer getAccountStatus() {
		return accountStatus;
	}
	
	
	public void setAccountStatus(Integer accountStatus) {
		this.accountStatus = accountStatus;
	}
		 	@Column(name = "bank_name")
	public String getBankName() {
		return bankName;
	}
	
	
	public void setBankName(String bankName) {
		this.bankName = bankName;
	}
		 	@Column(name = "bank_code")
	public String getBankCode() {
		return bankCode;
	}
	
	
	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
    @Column(name = "account_type")
    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
    @Column(name = "account_name")
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    @Column(name = "zone_id")
    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }
    @Column(name = "server_user_uuid")
    public String getServerUserUUID() {
        return serverUserUUID;
    }

    public void setServerUserUUID(String serverUserUUID) {
        this.serverUserUUID = serverUserUUID;
    }
    @Column(name = "customer_account_uuid")
    public String getCustomerAccountUUID() {
        return customerAccountUUID;
    }

    public void setCustomerAccountUUID(String customerAccountUUID) {
        this.customerAccountUUID = customerAccountUUID;
    }
    @Column(name = "balance_tobe_settled")
    public BigDecimal getBalanceTobeSettled() {
        return balanceTobeSettled;
    }

    public void setBalanceTobeSettled(BigDecimal balanceTobeSettled) {
        this.balanceTobeSettled = balanceTobeSettled;
    }
}

