/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.User;
import com.ptteng.employment.common.service.UserService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class UserSCAClient implements UserService {

    private UserService userService;

    public UserService getUserService() {
        return userService;
    }


    public void setUserService(UserService userService) {
        this.userService = userService;
    }


    @Override
    public Long insert(User user) throws ServiceException, ServiceDaoException {

        return userService.insert(user);


    }


    @Override
    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException {

        return userService.insertList(userList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return userService.delete(id);


    }


    @Override
    public boolean update(User user) throws ServiceException, ServiceDaoException {

        return userService.update(user);


    }


    @Override
    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException {

        return userService.updateList(userList);


    }


    @Override
    public User getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return userService.getObjectById(id);


    }


    @Override
    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return userService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserIdByIdNumberAndCustomerId(String idNumber, Long customerId) throws ServiceException, ServiceDaoException {

        return userService.getUserIdByIdNumberAndCustomerId(idNumber, customerId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userService.getUserIdsByCustomerId(customerId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserIdsByIdNumberAndStatus(String idNumber, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userService.getUserIdsByIdNumberAndStatus(idNumber, status, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserIdsByCustomerIdAndStatus(Long customerId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userService.getUserIdsByCustomerIdAndStatus(customerId, status, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserIdsByIdNumber(String idNumber, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userService.getUserIdsByIdNumber(idNumber, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return userService.countUserIdsByCustomerId(customerId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserIdsByIdNumberAndStatus(String idNumber, Integer status) throws ServiceException, ServiceDaoException {

        return userService.countUserIdsByIdNumberAndStatus(idNumber, status);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserIdsByCustomerIdAndStatus(Long customerId, Integer status) throws ServiceException, ServiceDaoException {

        return userService.countUserIdsByCustomerIdAndStatus(customerId, status);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserIdsByIdNumber(String idNumber) throws ServiceException, ServiceDaoException {

        return userService.countUserIdsByIdNumber(idNumber);


    }

    @Override
    public Long getUserIdByOpenIdAndMobile(String openId, String mobile) throws ServiceException, ServiceDaoException {
        return userService.getUserIdByOpenIdAndMobile(openId,mobile);
    }

    @Override
    public Long getUserIdByOpenId(String openId) throws ServiceException, ServiceDaoException {
        return userService.getUserIdByOpenId(openId);
    }

    @Override
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userService.getUserIds(start, limit);
    }

    @Override
    public Integer countUserIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userService.countUserIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        userService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.userService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.userService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

