/**
 * 
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.ProjectComment;
import com.ptteng.employment.common.service.ProjectCommentService;

import java.util.List;
import java.util.Map;

public class ProjectCommentSCAClient implements ProjectCommentService {

    private ProjectCommentService projectCommentService;

	public ProjectCommentService getProjectCommentService() {
		return projectCommentService;
	}
	
	
	public void setProjectCommentService(ProjectCommentService projectCommentService) {
		this.projectCommentService =projectCommentService;
	}
	
	
			   
		@Override
		public Long insert(ProjectComment projectComment)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.insert(projectComment);
		          
		
		}	
		  
    	   
		@Override
		public List<ProjectComment> insertList(List<ProjectComment> projectCommentList)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.insertList(projectCommentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(ProjectComment projectComment)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.update(projectComment);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProjectComment> projectCommentList)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.updateList(projectCommentList);
		          
		
		}	
		  
    	   
		@Override
		public ProjectComment getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<ProjectComment> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProjectCommentIdsByProjectId(Long projectId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.getProjectCommentIdsByProjectId(projectId,start,limit);
	
	
	}

    @Override
    public Long getProjectCommentIdsByProjectIdAndUserId(Long projectId, Long userId) throws ServiceException, ServiceDaoException {
        return projectCommentService.getProjectCommentIdsByProjectIdAndUserId(projectId, userId);
    }


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProjectCommentIdsByUserId(Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.getProjectCommentIdsByUserId(userId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProjectCommentIdsByProjectId(Long projectId)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.countProjectCommentIdsByProjectId(projectId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProjectCommentIdsByUserId(Long userId)throws ServiceException, ServiceDaoException{
		
		return projectCommentService.countProjectCommentIdsByUserId(userId);
	
	
	}
	
		
	
		@Override
	public List<Long> getProjectCommentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return projectCommentService.getProjectCommentIds(start, limit);
	}

	@Override
	public Integer countProjectCommentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return projectCommentService.countProjectCommentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return projectCommentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return projectCommentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   projectCommentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.projectCommentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.projectCommentService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

