/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.InvoiceCategory;
import com.ptteng.employment.common.service.InvoiceCategoryService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InvoiceCategorySCAClient implements InvoiceCategoryService {

    private InvoiceCategoryService invoiceCategoryService;

    public InvoiceCategoryService getInvoiceCategoryService() {
        return invoiceCategoryService;
    }


    public void setInvoiceCategoryService(InvoiceCategoryService invoiceCategoryService) {
        this.invoiceCategoryService = invoiceCategoryService;
    }


    @Override
    public Long insert(InvoiceCategory invoiceCategory) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.insert(invoiceCategory);


    }


    @Override
    public List<InvoiceCategory> insertList(List<InvoiceCategory> invoiceCategoryList) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.insertList(invoiceCategoryList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.delete(id);


    }


    @Override
    public boolean update(InvoiceCategory invoiceCategory) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.update(invoiceCategory);


    }


    @Override
    public boolean updateList(List<InvoiceCategory> invoiceCategoryList) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.updateList(invoiceCategoryList);


    }


    @Override
    public InvoiceCategory getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.getObjectById(id);


    }


    @Override
    public List<InvoiceCategory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceCategoryIdsByServiceProviderId(Long serviceProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.getInvoiceCategoryIdsByServiceProviderId(serviceProviderId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceCategoryIdsByServiceProviderId(Long serviceProviderId) throws ServiceException, ServiceDaoException {

        return invoiceCategoryService.countInvoiceCategoryIdsByServiceProviderId(serviceProviderId);


    }


    @Override
    public List<Long> getInvoiceCategoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceCategoryService.getInvoiceCategoryIds(start, limit);
    }

    @Override
    public Integer countInvoiceCategoryIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceCategoryService.countInvoiceCategoryIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceCategoryService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceCategoryService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        invoiceCategoryService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceCategoryService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceCategoryService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

