package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.ProjectUser;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ProjectUserService extends BaseDaoService {


    public Long insert(ProjectUser projectUser) throws ServiceException, ServiceDaoException;


    public List<ProjectUser> insertList(List<ProjectUser> projectUserList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ProjectUser projectUser) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ProjectUser> projectUserList) throws ServiceException, ServiceDaoException;


    public ProjectUser getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ProjectUser> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProjectUserIdsByProjectId(Long projectId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getProjectUserIdByProjectIdAndUserId(Long projectId, Long userId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProjectUserIdsByProjectId(Long projectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProjectUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProjectUserIds() throws ServiceException, ServiceDaoException;


}

