package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.ProjectResult;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ProjectResultService extends BaseDaoService {


    public Long insert(ProjectResult projectResult) throws ServiceException, ServiceDaoException;


    public List<ProjectResult> insertList(List<ProjectResult> projectResultList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ProjectResult projectResult) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ProjectResult> projectResultList) throws ServiceException, ServiceDaoException;


    public ProjectResult getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ProjectResult> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProjectResultIdsByProjectId(Long projectId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProjectResultIdsByProjectId(Long projectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProjectResultIdsByProjectIdAndUserId(Long projectId,Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProjectResultIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProjectResultIds() throws ServiceException, ServiceDaoException;


}

