package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.NoticeHistory;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface NoticeHistoryService extends BaseDaoService {

	



   		   
		
		public Long insert(NoticeHistory noticeHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<NoticeHistory> insertList(List<NoticeHistory> noticeHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(NoticeHistory noticeHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<NoticeHistory> noticeHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public NoticeHistory getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<NoticeHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countNoticeHistoryIdsByUserIdAndUserType(Long userId, String userType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countNoticeHistoryIdsByNoticeId(Long noticeId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getNoticeHistoryIdsByUserIdAndUserType(Long userId, String userType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getNoticeHistoryIdsByNoticeId(Long noticeId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getNoticeHistoryIdByNoticeIdAndUserIdAndUserType(Long noticeId, Long userId, String userType)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getNoticeHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countNoticeHistoryIds() throws ServiceException, ServiceDaoException;
	

}

