package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.GroupUser;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface GroupUserService extends BaseDaoService {

	



   		   
		
		public Long insert(GroupUser groupUser)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GroupUser> insertList(List<GroupUser> groupUserList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(GroupUser groupUser)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<GroupUser> groupUserList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public GroupUser getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GroupUser> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGroupUserIdsByGroupId(Long groupId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGroupUserIdsByUserTypeAndUserTotal(String userType, Integer userTotal)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGroupUserIdsByGroupId(Long groupId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGroupUserIdsByUserIdAndUserType(Long userId,String  userType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGroupUserIdsByGroupIdAndUserType(Long groupId,String  userType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGroupUserIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGroupUserIds() throws ServiceException, ServiceDaoException;
	

}

