/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.employment.common.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="customer_role")
public class CustomerRole
implements Serializable {
    public static final String STATUS_USING = "using";
    public static final String STATUS_STOPPED = "stopped";
    private static final long serialVersionUID = 8483443024528168433L;
    private Long id;
    private Long customerId;
    private String name;
    private Set<Long> permissionsSet;
    private String permissions;
    private String status;
    private Integer level;
    private Long updateAt;
    private Long updateBy;
    private Long createAt;
    private Long createBy;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="permissions")
    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
        Gson gson = new GsonBuilder().create();
        Map map = (Map)gson.fromJson(this.permissions, new TypeToken<Map<Long, Object>>(){}.getType());
        this.permissionsSet = new HashSet(map.keySet());
    }

    @Column(name="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="update_at")
    public Long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name="update_by")
    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name="create_at")
    public Long getCreateAt() {
        return this.createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name="create_by")
    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name="customer_id")
    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name="level")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Transient
    public Set<Long> getPermissionsSet() {
        if (StringUtils.isBlank((CharSequence)this.permissions)) {
            return new HashSet<Long>();
        }
        if (this.permissionsSet == null) {
            Gson gson = new GsonBuilder().create();
            Map map = (Map)gson.fromJson(this.permissions, new TypeToken<Map<Long, Object>>(){}.getType());
            this.permissionsSet = new HashSet(map.keySet());
        }
        return this.permissionsSet;
    }

    public void setPermissionsSet(Set<Long> permissionsSet) {
        this.permissionsSet = permissionsSet;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

