/**
 *
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.CustomerRoleModule;
import com.ptteng.employment.common.service.CustomerRoleModuleService;
import org.osoa.sca.annotations.Reference;

import java.util.List;
import java.util.Map;

public class CustomerRoleModuleSCAClient implements CustomerRoleModuleService {

    private CustomerRoleModuleService customerRoleModuleService;

    public CustomerRoleModuleService getCustomerRoleModuleService() {
        return customerRoleModuleService;
    }

    @Reference
    public void setCustomerRoleModuleService(CustomerRoleModuleService customerRoleModuleService) {
        this.customerRoleModuleService = customerRoleModuleService;
    }


    @Override
    public Long insert(CustomerRoleModule roleModule) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.insert(roleModule);


    }


    @Override
    public List<CustomerRoleModule> insertList(List<CustomerRoleModule> roleModuleList) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.insertList(roleModuleList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.delete(id);


    }


    @Override
    public boolean update(CustomerRoleModule roleModule) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.update(roleModule);


    }


    @Override
    public boolean updateList(List<CustomerRoleModule> roleModuleList) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.updateList(roleModuleList);


    }


    @Override
    public CustomerRoleModule getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.getObjectById(id);


    }


    @Override
    public List<CustomerRoleModule> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerRoleModuleIdsByRid(Long rid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.getCustomerRoleModuleIdsByRid(rid, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerRoleModuleIdsByMid(Long mid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.getCustomerRoleModuleIdsByMid(mid, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerRoleModuleIdsByRid(Long rid) throws ServiceException, ServiceDaoException {

        return customerRoleModuleService.countCustomerRoleModuleIdsByRid(rid);


    }


    @Override
    public List<Long> getCustomerRoleModuleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleModuleService.getCustomerRoleModuleIds(start, limit);
    }

    @Override
    public Integer countCustomerRoleModuleIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleModuleService.countCustomerRoleModuleIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleModuleService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return customerRoleModuleService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return customerRoleModuleService.getMapListByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRoleModuleService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        customerRoleModuleService.deleteList(clz, ids);

    }


}

